/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.model.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.sync.SyncClientMinBuildException;
import com.liferay.sync.SyncServicesUnavailableException;
import com.liferay.sync.exception.SyncDeviceActiveException;
import com.liferay.sync.exception.SyncDeviceWipeException;
import com.liferay.sync.model.impl.SyncDeviceBaseImpl;
import com.liferay.sync.service.SyncDeviceLocalServiceUtil;
import com.liferay.sync.service.internal.configuration.SyncServiceConfigurationValues;

@ProviderType
public class SyncDeviceImpl
extends SyncDeviceBaseImpl {
    public void checkStatus() throws PortalException {
        if (this.getStatus() == 1) {
            throw new SyncDeviceActiveException();
        }
        if (this.getStatus() == 2) {
            SyncDeviceLocalServiceUtil.updateSyncDevice((long)this.getSyncDeviceId(), (String)this.getType(), (long)this.getBuildNumber(), (int)this.getFeatureSet(), (String)this.getHostname(), (int)3);
            throw new SyncDeviceWipeException();
        }
        if (!PrefsPropsUtil.getBoolean((long)this.getCompanyId(), (String)"sync.services.enabled", (boolean)SyncServiceConfigurationValues.SYNC_SERVICES_ENABLED)) {
            throw new SyncServicesUnavailableException();
        }
        if (!this.isSupported()) {
            throw new SyncClientMinBuildException();
        }
    }

    @Override
    public boolean hasSetModifiedDate() {
        return true;
    }

    public boolean isSupported() {
        int minBuildNumber = 0;
        String type = this.getType();
        if (type.startsWith("desktop")) {
            minBuildNumber = PrefsPropsUtil.getInteger((long)this.getCompanyId(), (String)"sync.client.min.build.desktop", (int)SyncServiceConfigurationValues.SYNC_CLIENT_MIN_BUILD_DESKTOP);
        } else if (type.equals("mobile-android")) {
            minBuildNumber = PrefsPropsUtil.getInteger((long)this.getCompanyId(), (String)"sync.client.min.build.android", (int)SyncServiceConfigurationValues.SYNC_CLIENT_MIN_BUILD_ANDROID);
        } else if (type.equals("mobile-ios")) {
            minBuildNumber = PrefsPropsUtil.getInteger((long)this.getCompanyId(), (String)"sync.client.min.build.ios", (int)SyncServiceConfigurationValues.SYNC_CLIENT_MIN_BUILD_IOS);
        }
        return this.getBuildNumber() >= (long)minBuildNumber;
    }

    public boolean supports(int featureSet) {
        return this.getFeatureSet() >= featureSet;
    }
}

