/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.internal.util;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.sync.model.SyncDLObject;
import com.liferay.sync.service.SyncDLObjectLocalService;
import com.liferay.sync.util.SyncHelper;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Deprecated
@Component(immediate=true, service={VerifyUtil.class})
public class VerifyUtil {
    private static final Log _log = LogFactoryUtil.getLog(VerifyUtil.class);
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLFolderLocalService _dlFolderLocalService;
    private long _dlFoldersAndFileEntriesCount;
    private long _dlFoldersAndFileEntriesTotalCount;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private SyncDLObjectLocalService _syncDLObjectLocalService;
    private long _syncDLObjectsCount;
    private long _syncDLObjectsTotalCount;
    @Reference
    private SyncHelper _syncHelper;

    public static void verify() throws Exception {
        VerifyUtil verifyUtil = new VerifyUtil();
        verifyUtil.doVerify();
    }

    public void doVerify() throws Exception {
        List groups = this._groupLocalService.getGroups(-1, -1);
        for (Group group : groups) {
            if (group.isStaged()) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Verifying group " + group.getGroupId()));
            }
            this.verifyDLFileEntriesAndFolders(group.getGroupId());
            this.verifySyncDLObjects(group.getGroupId());
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Verification completed");
        }
    }

    protected void logCount(long count, long totalCount, String name) {
        if (_log.isDebugEnabled() && count % 1000L == 0L) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Verified ", count, "/", totalCount, " ", name}));
        }
    }

    protected void verifyDLFileEntriesAndFolders(long groupId) throws Exception {
        this._dlFoldersAndFileEntriesCount = 0L;
        ActionableDynamicQuery dlFolderActionableDynamicQuery = this._dlFolderLocalService.getActionableDynamicQuery();
        dlFolderActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property hiddenProperty = PropertyFactoryUtil.forName((String)"hidden");
            dynamicQuery.add(hiddenProperty.eq((Object)false));
            Property mountPointProperty = PropertyFactoryUtil.forName((String)"mountPoint");
            dynamicQuery.add(mountPointProperty.eq((Object)false));
            Property statusProperty = PropertyFactoryUtil.forName((String)"status");
            int[] workflowConstants = new int[]{0, 8};
            dynamicQuery.add(statusProperty.in(workflowConstants));
        });
        dlFolderActionableDynamicQuery.setGroupId(groupId);
        dlFolderActionableDynamicQuery.setPerformActionMethod(dlFolder -> {
            ++this._dlFoldersAndFileEntriesCount;
            this.logCount(this._dlFoldersAndFileEntriesCount, this._dlFoldersAndFileEntriesTotalCount, "DL folders and DL file entries");
            try {
                if (dlFolder.getStatus() == 0) {
                    this._syncHelper.addSyncDLObject(this._syncHelper.toSyncDLObject(dlFolder, 0L, "", "add"), this._syncDLObjectLocalService);
                } else {
                    this._syncHelper.addSyncDLObject(this._syncHelper.toSyncDLObject(dlFolder, 0L, "", "trash"), this._syncDLObjectLocalService);
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        });
        ActionableDynamicQuery dlFileEntryActionableDynamicQuery = this._dlFileEntryLocalService.getActionableDynamicQuery();
        dlFileEntryActionableDynamicQuery.setGroupId(groupId);
        dlFileEntryActionableDynamicQuery.setPerformActionMethod(dlFileEntry -> {
            ++this._dlFoldersAndFileEntriesCount;
            this.logCount(this._dlFoldersAndFileEntriesCount, this._dlFoldersAndFileEntriesTotalCount, "DL folders and DL file entries");
            if (dlFileEntry.getStatus() != 0 && !dlFileEntry.isInTrash()) {
                return;
            }
            try {
                SyncDLObject syncDLObject = this._syncDLObjectLocalService.fetchSyncDLObject("file", dlFileEntry.getFileEntryId());
                if (syncDLObject != null) {
                    Date modifiedDate = dlFileEntry.getModifiedDate();
                    if (syncDLObject.getModifiedTime() >= modifiedDate.getTime()) {
                        return;
                    }
                }
                String event = null;
                event = dlFileEntry.getStatus() == 0 ? "add" : "trash";
                if (dlFileEntry.isCheckedOut()) {
                    SyncDLObject approvedFileEntrySyncDLObject = this._syncHelper.toSyncDLObject(dlFileEntry, event, !dlFileEntry.isInTrash(), true);
                    this._syncHelper.addSyncDLObject(approvedFileEntrySyncDLObject, this._syncDLObjectLocalService);
                }
                this._syncHelper.addSyncDLObject(this._syncHelper.toSyncDLObject(dlFileEntry, event, !dlFileEntry.isInTrash()), this._syncDLObjectLocalService);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        });
        this._dlFoldersAndFileEntriesTotalCount = dlFolderActionableDynamicQuery.performCount() + dlFileEntryActionableDynamicQuery.performCount();
        dlFolderActionableDynamicQuery.performActions();
        dlFileEntryActionableDynamicQuery.performActions();
        this.logCount(this._dlFoldersAndFileEntriesCount, this._dlFoldersAndFileEntriesTotalCount, "DL folders and DL file entries");
    }

    protected void verifySyncDLObjects(long groupId) throws Exception {
        this._syncDLObjectsCount = 0L;
        ActionableDynamicQuery actionableDynamicQuery = this._syncDLObjectLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property eventProperty = PropertyFactoryUtil.forName((String)"event");
            dynamicQuery.add(eventProperty.ne((Object)"delete"));
            Property repositoryIdProperty = PropertyFactoryUtil.forName((String)"repositoryId");
            dynamicQuery.add(repositoryIdProperty.eq((Object)groupId));
        });
        actionableDynamicQuery.setPerformActionMethod(syncDLObject -> {
            DLFileEntry dlFileEntry;
            ++this._syncDLObjectsCount;
            this.logCount(this._syncDLObjectsCount, this._syncDLObjectsTotalCount, "Sync DL objects");
            String type = syncDLObject.getType();
            if (type.equals("file")) {
                DLFileEntry dlFileEntry2 = this._dlFileEntryLocalService.fetchDLFileEntry(syncDLObject.getTypePK());
                if (dlFileEntry2 == null) {
                    syncDLObject.setModifiedTime(System.currentTimeMillis());
                    syncDLObject.setEvent("delete");
                    this._syncHelper.addSyncDLObject(syncDLObject, this._syncDLObjectLocalService);
                }
            } else if (type.equals("folder")) {
                DLFolder dlFolder = this._dlFolderLocalService.fetchDLFolder(syncDLObject.getTypePK());
                if (dlFolder == null) {
                    syncDLObject.setEvent("delete");
                    syncDLObject.setModifiedTime(System.currentTimeMillis());
                    this._syncHelper.addSyncDLObject(syncDLObject, this._syncDLObjectLocalService);
                }
            } else if (type.equals("privateWorkingCopy") && ((dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(syncDLObject.getTypePK())) == null || !this._dlFileEntryLocalService.isFileEntryCheckedOut(syncDLObject.getTypePK()))) {
                this._syncDLObjectLocalService.deleteSyncDLObject(syncDLObject);
            }
        });
        this._syncDLObjectsTotalCount = actionableDynamicQuery.performCount();
        actionableDynamicQuery.performActions();
        this.logCount(this._syncDLObjectsTotalCount, this._syncDLObjectsTotalCount, "Sync DL objects");
    }
}

