/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.internal.messaging;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.sync.service.DLSyncEventLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.sync.model.SyncDLObject;
import com.liferay.sync.model.impl.SyncDLObjectImpl;
import com.liferay.sync.service.SyncDLObjectLocalService;
import com.liferay.sync.util.SyncHelper;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"destination.name=liferay/document_library_sync_event_processor"}, service={MessageListener.class})
public class DLSyncEventMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(DLSyncEventMessageListener.class);
    private DLFileEntryLocalService _dlFileEntryLocalService;
    private DLFolderLocalService _dlFolderLocalService;
    private DLSyncEventLocalService _dlSyncEventLocalService;
    private SyncDLObjectLocalService _syncDLObjectLocalService;
    @Reference
    private SyncHelper _syncHelper;

    @Activate
    protected void activate() {
        ActionableDynamicQuery actionableDynamicQuery = this._dlSyncEventLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property modifiedTimeProperty = PropertyFactoryUtil.forName((String)"modifiedTime");
            dynamicQuery.add(modifiedTimeProperty.gt((Object)this._syncDLObjectLocalService.getLatestModifiedTime()));
        });
        actionableDynamicQuery.setPerformActionMethod(dlSyncEvent -> {
            try {
                this.processDLSyncEvent(dlSyncEvent.getModifiedTime(), dlSyncEvent.getEvent(), dlSyncEvent.getType(), dlSyncEvent.getTypePK());
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        });
        try {
            actionableDynamicQuery.performActions();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void doReceive(Message message) throws Exception {
        String event = message.getString("event");
        long modifiedTime = message.getLong("modifiedTime");
        String type = message.getString("type");
        long typePK = message.getLong("typePK");
        try {
            this.processDLSyncEvent(modifiedTime, event, type, typePK);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void processDLSyncEvent(long modifiedTime, String event, String type, long typePK) throws Exception {
        SyncDLObjectImpl syncDLObject = null;
        if (event.equals("delete")) {
            syncDLObject = new SyncDLObjectImpl();
            this.setUser(syncDLObject);
            syncDLObject.setModifiedTime(System.currentTimeMillis());
            syncDLObject.setEvent(event);
            syncDLObject.setType(type);
            syncDLObject.setTypePK(typePK);
        } else if (type.equals("file")) {
            DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(typePK);
            if (dlFileEntry == null) {
                return;
            }
            DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
            if (dlFileVersion.isPending()) {
                return;
            }
            boolean calculateChecksum = false;
            String checksum = this._syncHelper.getChecksum(modifiedTime, typePK);
            if (checksum == null && !dlFileEntry.isInTrash()) {
                calculateChecksum = true;
            }
            syncDLObject = this._syncHelper.toSyncDLObject(dlFileEntry, event, calculateChecksum);
            syncDLObject.setModifiedTime(modifiedTime);
            if (checksum != null) {
                syncDLObject.setChecksum(checksum);
            }
            if (event.equals("trash")) {
                this.setUser(syncDLObject);
            }
            syncDLObject.setLanTokenKey(this._syncHelper.getLanTokenKey(modifiedTime, typePK, false));
        } else {
            DLFolder dlFolder = this._dlFolderLocalService.fetchDLFolder(typePK);
            if (dlFolder == null || !this._syncHelper.isSupportedFolder(dlFolder)) {
                return;
            }
            syncDLObject = this._syncHelper.toSyncDLObject(dlFolder, event);
            syncDLObject.setModifiedTime(modifiedTime);
        }
        this._syncHelper.addSyncDLObject((SyncDLObject)syncDLObject, this._syncDLObjectLocalService);
    }

    @Reference(unbind="-")
    protected void setDLFileEntryLocalService(DLFileEntryLocalService dlFileEntryLocalService) {
        this._dlFileEntryLocalService = dlFileEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setDLFolderLocalService(DLFolderLocalService dlFolderLocalService) {
        this._dlFolderLocalService = dlFolderLocalService;
    }

    @Reference(unbind="-")
    protected void setDLSyncEventLocalService(DLSyncEventLocalService dlSyncEventLocalService) {
        this._dlSyncEventLocalService = dlSyncEventLocalService;
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    @Reference(unbind="-")
    protected void setSyncDLObjectLocalService(SyncDLObjectLocalService syncDLObjectLocalService) {
        this._syncDLObjectLocalService = syncDLObjectLocalService;
    }

    protected void setUser(SyncDLObject syncDLObject) {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null) {
            User user = permissionChecker.getUser();
            syncDLObject.setUserId(user.getUserId());
            syncDLObject.setUserName(user.getFullName());
        }
    }
}

