/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.sync.exception.NoSuchDeviceException;
import com.liferay.sync.model.SyncDevice;
import com.liferay.sync.model.impl.SyncDeviceImpl;
import com.liferay.sync.model.impl.SyncDeviceModelImpl;
import com.liferay.sync.service.persistence.SyncDevicePersistence;
import com.liferay.sync.service.persistence.impl.constants.SyncPersistenceConstants;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={SyncDevicePersistence.class})
public class SyncDevicePersistenceImpl
extends BasePersistenceImpl<SyncDevice>
implements SyncDevicePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = SyncDeviceImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "syncDevice.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(syncDevice.uuid IS NULL OR syncDevice.uuid = '')";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "syncDevice.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(syncDevice.uuid IS NULL OR syncDevice.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "syncDevice.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByUserId;
    private FinderPath _finderPathWithoutPaginationFindByUserId;
    private FinderPath _finderPathCountByUserId;
    private static final String _FINDER_COLUMN_USERID_USERID_2 = "syncDevice.userId = ?";
    private FinderPath _finderPathWithPaginationFindByC_U;
    private FinderPath _finderPathWithPaginationCountByC_U;
    private static final String _FINDER_COLUMN_C_U_COMPANYID_2 = "syncDevice.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_U_USERNAME_2 = "lower(syncDevice.userName) LIKE ?";
    private static final String _FINDER_COLUMN_C_U_USERNAME_3 = "(syncDevice.userName IS NULL OR syncDevice.userName LIKE '')";
    private boolean _columnBitmaskEnabled;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_SYNCDEVICE = "SELECT syncDevice FROM SyncDevice syncDevice";
    private static final String _SQL_SELECT_SYNCDEVICE_WHERE = "SELECT syncDevice FROM SyncDevice syncDevice WHERE ";
    private static final String _SQL_COUNT_SYNCDEVICE = "SELECT COUNT(syncDevice) FROM SyncDevice syncDevice";
    private static final String _SQL_COUNT_SYNCDEVICE_WHERE = "SELECT COUNT(syncDevice) FROM SyncDevice syncDevice WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "syncDevice.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No SyncDevice exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No SyncDevice exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(SyncDevicePersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid", "type"});

    public List<SyncDevice> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<SyncDevice> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<SyncDevice> findByUuid(String uuid, int start, int end, OrderByComparator<SyncDevice> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<SyncDevice> findByUuid(String uuid, int start, int end, OrderByComparator<SyncDevice> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (SyncDevice syncDevice : list) {
                if (uuid.equals(syncDevice.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_SYNCDEVICE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY syncDevice.syncDeviceId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public SyncDevice findByUuid_First(String uuid, OrderByComparator<SyncDevice> orderByComparator) throws NoSuchDeviceException {
        SyncDevice syncDevice = this.fetchByUuid_First(uuid, orderByComparator);
        if (syncDevice != null) {
            return syncDevice;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchDeviceException(sb.toString());
    }

    public SyncDevice fetchByUuid_First(String uuid, OrderByComparator<SyncDevice> orderByComparator) {
        List<SyncDevice> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public SyncDevice findByUuid_Last(String uuid, OrderByComparator<SyncDevice> orderByComparator) throws NoSuchDeviceException {
        SyncDevice syncDevice = this.fetchByUuid_Last(uuid, orderByComparator);
        if (syncDevice != null) {
            return syncDevice;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchDeviceException(sb.toString());
    }

    public SyncDevice fetchByUuid_Last(String uuid, OrderByComparator<SyncDevice> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<SyncDevice> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public SyncDevice[] findByUuid_PrevAndNext(long syncDeviceId, String uuid, OrderByComparator<SyncDevice> orderByComparator) throws NoSuchDeviceException {
        uuid = Objects.toString(uuid, "");
        SyncDevice syncDevice = this.findByPrimaryKey(syncDeviceId);
        Session session = null;
        try {
            session = this.openSession();
            SyncDevice[] array = new SyncDeviceImpl[]{this.getByUuid_PrevAndNext(session, syncDevice, uuid, orderByComparator, true), syncDevice, this.getByUuid_PrevAndNext(session, syncDevice, uuid, orderByComparator, false)};
            SyncDevice[] syncDeviceArray = array;
            return syncDeviceArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected SyncDevice getByUuid_PrevAndNext(Session session, SyncDevice syncDevice, String uuid, OrderByComparator<SyncDevice> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_SYNCDEVICE_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY syncDevice.syncDeviceId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)syncDevice)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (SyncDevice)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (SyncDevice syncDevice : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)syncDevice);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_SYNCDEVICE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<SyncDevice> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<SyncDevice> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<SyncDevice> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<SyncDevice> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<SyncDevice> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<SyncDevice> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (SyncDevice syncDevice : list) {
                if (uuid.equals(syncDevice.getUuid()) && companyId == syncDevice.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_SYNCDEVICE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY syncDevice.syncDeviceId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public SyncDevice findByUuid_C_First(String uuid, long companyId, OrderByComparator<SyncDevice> orderByComparator) throws NoSuchDeviceException {
        SyncDevice syncDevice = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (syncDevice != null) {
            return syncDevice;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchDeviceException(sb.toString());
    }

    public SyncDevice fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<SyncDevice> orderByComparator) {
        List<SyncDevice> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public SyncDevice findByUuid_C_Last(String uuid, long companyId, OrderByComparator<SyncDevice> orderByComparator) throws NoSuchDeviceException {
        SyncDevice syncDevice = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (syncDevice != null) {
            return syncDevice;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchDeviceException(sb.toString());
    }

    public SyncDevice fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<SyncDevice> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<SyncDevice> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public SyncDevice[] findByUuid_C_PrevAndNext(long syncDeviceId, String uuid, long companyId, OrderByComparator<SyncDevice> orderByComparator) throws NoSuchDeviceException {
        uuid = Objects.toString(uuid, "");
        SyncDevice syncDevice = this.findByPrimaryKey(syncDeviceId);
        Session session = null;
        try {
            session = this.openSession();
            SyncDevice[] array = new SyncDeviceImpl[]{this.getByUuid_C_PrevAndNext(session, syncDevice, uuid, companyId, orderByComparator, true), syncDevice, this.getByUuid_C_PrevAndNext(session, syncDevice, uuid, companyId, orderByComparator, false)};
            SyncDevice[] syncDeviceArray = array;
            return syncDeviceArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected SyncDevice getByUuid_C_PrevAndNext(Session session, SyncDevice syncDevice, String uuid, long companyId, OrderByComparator<SyncDevice> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_SYNCDEVICE_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
        }
        sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY syncDevice.syncDeviceId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)syncDevice)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (SyncDevice)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (SyncDevice syncDevice : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)syncDevice);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_SYNCDEVICE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<SyncDevice> findByUserId(long userId) {
        return this.findByUserId(userId, -1, -1, null);
    }

    public List<SyncDevice> findByUserId(long userId, int start, int end) {
        return this.findByUserId(userId, start, end, null);
    }

    public List<SyncDevice> findByUserId(long userId, int start, int end, OrderByComparator<SyncDevice> orderByComparator) {
        return this.findByUserId(userId, start, end, orderByComparator, true);
    }

    public List<SyncDevice> findByUserId(long userId, int start, int end, OrderByComparator<SyncDevice> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUserId;
                finderArgs = new Object[]{userId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUserId;
            finderArgs = new Object[]{userId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (SyncDevice syncDevice : list) {
                if (userId == syncDevice.getUserId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_SYNCDEVICE_WHERE);
            sb.append(_FINDER_COLUMN_USERID_USERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY syncDevice.syncDeviceId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public SyncDevice findByUserId_First(long userId, OrderByComparator<SyncDevice> orderByComparator) throws NoSuchDeviceException {
        SyncDevice syncDevice = this.fetchByUserId_First(userId, orderByComparator);
        if (syncDevice != null) {
            return syncDevice;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append("}");
        throw new NoSuchDeviceException(sb.toString());
    }

    public SyncDevice fetchByUserId_First(long userId, OrderByComparator<SyncDevice> orderByComparator) {
        List<SyncDevice> list = this.findByUserId(userId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public SyncDevice findByUserId_Last(long userId, OrderByComparator<SyncDevice> orderByComparator) throws NoSuchDeviceException {
        SyncDevice syncDevice = this.fetchByUserId_Last(userId, orderByComparator);
        if (syncDevice != null) {
            return syncDevice;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append("}");
        throw new NoSuchDeviceException(sb.toString());
    }

    public SyncDevice fetchByUserId_Last(long userId, OrderByComparator<SyncDevice> orderByComparator) {
        int count = this.countByUserId(userId);
        if (count == 0) {
            return null;
        }
        List<SyncDevice> list = this.findByUserId(userId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public SyncDevice[] findByUserId_PrevAndNext(long syncDeviceId, long userId, OrderByComparator<SyncDevice> orderByComparator) throws NoSuchDeviceException {
        SyncDevice syncDevice = this.findByPrimaryKey(syncDeviceId);
        Session session = null;
        try {
            session = this.openSession();
            SyncDevice[] array = new SyncDeviceImpl[]{this.getByUserId_PrevAndNext(session, syncDevice, userId, orderByComparator, true), syncDevice, this.getByUserId_PrevAndNext(session, syncDevice, userId, orderByComparator, false)};
            SyncDevice[] syncDeviceArray = array;
            return syncDeviceArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected SyncDevice getByUserId_PrevAndNext(Session session, SyncDevice syncDevice, long userId, OrderByComparator<SyncDevice> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_SYNCDEVICE_WHERE);
        sb.append(_FINDER_COLUMN_USERID_USERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY syncDevice.syncDeviceId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(userId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)syncDevice)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (SyncDevice)list.get(1);
        }
        return null;
    }

    public void removeByUserId(long userId) {
        for (SyncDevice syncDevice : this.findByUserId(userId, -1, -1, null)) {
            this.remove((BaseModel)syncDevice);
        }
    }

    public int countByUserId(long userId) {
        FinderPath finderPath = this._finderPathCountByUserId;
        Object[] finderArgs = new Object[]{userId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_SYNCDEVICE_WHERE);
            sb.append(_FINDER_COLUMN_USERID_USERID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<SyncDevice> findByC_U(long companyId, String userName) {
        return this.findByC_U(companyId, userName, -1, -1, null);
    }

    public List<SyncDevice> findByC_U(long companyId, String userName, int start, int end) {
        return this.findByC_U(companyId, userName, start, end, null);
    }

    public List<SyncDevice> findByC_U(long companyId, String userName, int start, int end, OrderByComparator<SyncDevice> orderByComparator) {
        return this.findByC_U(companyId, userName, start, end, orderByComparator, true);
    }

    public List<SyncDevice> findByC_U(long companyId, String userName, int start, int end, OrderByComparator<SyncDevice> orderByComparator, boolean useFinderCache) {
        userName = Objects.toString(userName, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        finderPath = this._finderPathWithPaginationFindByC_U;
        finderArgs = new Object[]{companyId, userName, start, end, orderByComparator};
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (SyncDevice syncDevice : list) {
                if (companyId == syncDevice.getCompanyId() && StringUtil.wildcardMatches((String)syncDevice.getUserName(), (String)userName, (char)'_', (char)'%', (char)'\\', (boolean)false)) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_SYNCDEVICE_WHERE);
            sb.append(_FINDER_COLUMN_C_U_COMPANYID_2);
            boolean bindUserName = false;
            if (userName.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_U_USERNAME_3);
            } else {
                bindUserName = true;
                sb.append(_FINDER_COLUMN_C_U_USERNAME_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY syncDevice.syncDeviceId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindUserName) {
                    queryPos.add(StringUtil.toLowerCase((String)userName));
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public SyncDevice findByC_U_First(long companyId, String userName, OrderByComparator<SyncDevice> orderByComparator) throws NoSuchDeviceException {
        SyncDevice syncDevice = this.fetchByC_U_First(companyId, userName, orderByComparator);
        if (syncDevice != null) {
            return syncDevice;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", userNameLIKE");
        sb.append(userName);
        sb.append("}");
        throw new NoSuchDeviceException(sb.toString());
    }

    public SyncDevice fetchByC_U_First(long companyId, String userName, OrderByComparator<SyncDevice> orderByComparator) {
        List<SyncDevice> list = this.findByC_U(companyId, userName, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public SyncDevice findByC_U_Last(long companyId, String userName, OrderByComparator<SyncDevice> orderByComparator) throws NoSuchDeviceException {
        SyncDevice syncDevice = this.fetchByC_U_Last(companyId, userName, orderByComparator);
        if (syncDevice != null) {
            return syncDevice;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", userNameLIKE");
        sb.append(userName);
        sb.append("}");
        throw new NoSuchDeviceException(sb.toString());
    }

    public SyncDevice fetchByC_U_Last(long companyId, String userName, OrderByComparator<SyncDevice> orderByComparator) {
        int count = this.countByC_U(companyId, userName);
        if (count == 0) {
            return null;
        }
        List<SyncDevice> list = this.findByC_U(companyId, userName, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public SyncDevice[] findByC_U_PrevAndNext(long syncDeviceId, long companyId, String userName, OrderByComparator<SyncDevice> orderByComparator) throws NoSuchDeviceException {
        userName = Objects.toString(userName, "");
        SyncDevice syncDevice = this.findByPrimaryKey(syncDeviceId);
        Session session = null;
        try {
            session = this.openSession();
            SyncDevice[] array = new SyncDeviceImpl[]{this.getByC_U_PrevAndNext(session, syncDevice, companyId, userName, orderByComparator, true), syncDevice, this.getByC_U_PrevAndNext(session, syncDevice, companyId, userName, orderByComparator, false)};
            SyncDevice[] syncDeviceArray = array;
            return syncDeviceArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected SyncDevice getByC_U_PrevAndNext(Session session, SyncDevice syncDevice, long companyId, String userName, OrderByComparator<SyncDevice> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_SYNCDEVICE_WHERE);
        sb.append(_FINDER_COLUMN_C_U_COMPANYID_2);
        boolean bindUserName = false;
        if (userName.isEmpty()) {
            sb.append(_FINDER_COLUMN_C_U_USERNAME_3);
        } else {
            bindUserName = true;
            sb.append(_FINDER_COLUMN_C_U_USERNAME_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY syncDevice.syncDeviceId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (bindUserName) {
            queryPos.add(StringUtil.toLowerCase((String)userName));
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)syncDevice)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (SyncDevice)list.get(1);
        }
        return null;
    }

    public void removeByC_U(long companyId, String userName) {
        for (SyncDevice syncDevice : this.findByC_U(companyId, userName, -1, -1, null)) {
            this.remove((BaseModel)syncDevice);
        }
    }

    public int countByC_U(long companyId, String userName) {
        userName = Objects.toString(userName, "");
        FinderPath finderPath = this._finderPathWithPaginationCountByC_U;
        Object[] finderArgs = new Object[]{companyId, userName};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_SYNCDEVICE_WHERE);
            sb.append(_FINDER_COLUMN_C_U_COMPANYID_2);
            boolean bindUserName = false;
            if (userName.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_U_USERNAME_3);
            } else {
                bindUserName = true;
                sb.append(_FINDER_COLUMN_C_U_USERNAME_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindUserName) {
                    queryPos.add(StringUtil.toLowerCase((String)userName));
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public SyncDevicePersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        dbColumnNames.put("type", "type_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(SyncDevice.class);
        this.setModelImplClass(SyncDeviceImpl.class);
        this.setModelPKClass(Long.TYPE);
    }

    public void cacheResult(SyncDevice syncDevice) {
        this.entityCache.putResult(this.entityCacheEnabled, SyncDeviceImpl.class, (Serializable)Long.valueOf(syncDevice.getPrimaryKey()), (Serializable)syncDevice);
        syncDevice.resetOriginalValues();
    }

    public void cacheResult(List<SyncDevice> syncDevices) {
        for (SyncDevice syncDevice : syncDevices) {
            if (this.entityCache.getResult(this.entityCacheEnabled, SyncDeviceImpl.class, (Serializable)Long.valueOf(syncDevice.getPrimaryKey())) == null) {
                this.cacheResult(syncDevice);
                continue;
            }
            syncDevice.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(SyncDeviceImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(SyncDevice syncDevice) {
        this.entityCache.removeResult(this.entityCacheEnabled, SyncDeviceImpl.class, (Serializable)Long.valueOf(syncDevice.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(List<SyncDevice> syncDevices) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (SyncDevice syncDevice : syncDevices) {
            this.entityCache.removeResult(this.entityCacheEnabled, SyncDeviceImpl.class, (Serializable)Long.valueOf(syncDevice.getPrimaryKey()));
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(this.entityCacheEnabled, SyncDeviceImpl.class, primaryKey);
        }
    }

    public SyncDevice create(long syncDeviceId) {
        SyncDeviceImpl syncDevice = new SyncDeviceImpl();
        syncDevice.setNew(true);
        syncDevice.setPrimaryKey(syncDeviceId);
        String uuid = PortalUUIDUtil.generate();
        syncDevice.setUuid(uuid);
        syncDevice.setCompanyId(CompanyThreadLocal.getCompanyId());
        return syncDevice;
    }

    public SyncDevice remove(long syncDeviceId) throws NoSuchDeviceException {
        return this.remove(Long.valueOf(syncDeviceId));
    }

    public SyncDevice remove(Serializable primaryKey) throws NoSuchDeviceException {
        Session session = null;
        try {
            session = this.openSession();
            SyncDevice syncDevice = (SyncDevice)session.get(SyncDeviceImpl.class, primaryKey);
            if (syncDevice == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchDeviceException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            SyncDevice syncDevice2 = (SyncDevice)this.remove((BaseModel)syncDevice);
            return syncDevice2;
        }
        catch (NoSuchDeviceException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected SyncDevice removeImpl(SyncDevice syncDevice) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)syncDevice)) {
                syncDevice = (SyncDevice)session.get(SyncDeviceImpl.class, syncDevice.getPrimaryKeyObj());
            }
            if (syncDevice != null) {
                session.delete((Object)syncDevice);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (syncDevice != null) {
            this.clearCache(syncDevice);
        }
        return syncDevice;
    }

    public SyncDevice updateImpl(SyncDevice syncDevice) {
        boolean isNew = syncDevice.isNew();
        if (!(syncDevice instanceof SyncDeviceModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(syncDevice.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)syncDevice);
                throw new IllegalArgumentException("Implement ModelWrapper in syncDevice proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom SyncDevice implementation " + syncDevice.getClass());
        }
        SyncDeviceModelImpl syncDeviceModelImpl = (SyncDeviceModelImpl)syncDevice;
        if (Validator.isNull((String)syncDevice.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            syncDevice.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && syncDevice.getCreateDate() == null) {
            if (serviceContext == null) {
                syncDevice.setCreateDate(now);
            } else {
                syncDevice.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!syncDeviceModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                syncDevice.setModifiedDate(now);
            } else {
                syncDevice.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (syncDevice.isNew()) {
                session.save((Object)syncDevice);
                syncDevice.setNew(false);
            } else {
                syncDevice = (SyncDevice)session.merge((Object)syncDevice);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!this._columnBitmaskEnabled) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{syncDeviceModelImpl.getUuid()};
            this.finderCache.removeResult(this._finderPathCountByUuid, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            args = new Object[]{syncDeviceModelImpl.getUuid(), syncDeviceModelImpl.getCompanyId()};
            this.finderCache.removeResult(this._finderPathCountByUuid_C, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            args = new Object[]{syncDeviceModelImpl.getUserId()};
            this.finderCache.removeResult(this._finderPathCountByUserId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUserId, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((syncDeviceModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid.getColumnBitmask()) != 0L) {
                args = new Object[]{syncDeviceModelImpl.getOriginalUuid()};
                this.finderCache.removeResult(this._finderPathCountByUuid, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
                args = new Object[]{syncDeviceModelImpl.getUuid()};
                this.finderCache.removeResult(this._finderPathCountByUuid, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            }
            if ((syncDeviceModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid_C.getColumnBitmask()) != 0L) {
                args = new Object[]{syncDeviceModelImpl.getOriginalUuid(), syncDeviceModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByUuid_C, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
                args = new Object[]{syncDeviceModelImpl.getUuid(), syncDeviceModelImpl.getCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByUuid_C, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            }
            if ((syncDeviceModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUserId.getColumnBitmask()) != 0L) {
                args = new Object[]{syncDeviceModelImpl.getOriginalUserId()};
                this.finderCache.removeResult(this._finderPathCountByUserId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUserId, args);
                args = new Object[]{syncDeviceModelImpl.getUserId()};
                this.finderCache.removeResult(this._finderPathCountByUserId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUserId, args);
            }
        }
        this.entityCache.putResult(this.entityCacheEnabled, SyncDeviceImpl.class, (Serializable)Long.valueOf(syncDevice.getPrimaryKey()), (Serializable)syncDevice, false);
        syncDevice.resetOriginalValues();
        return syncDevice;
    }

    public SyncDevice findByPrimaryKey(Serializable primaryKey) throws NoSuchDeviceException {
        SyncDevice syncDevice = (SyncDevice)this.fetchByPrimaryKey(primaryKey);
        if (syncDevice == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchDeviceException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return syncDevice;
    }

    public SyncDevice findByPrimaryKey(long syncDeviceId) throws NoSuchDeviceException {
        return this.findByPrimaryKey(Long.valueOf(syncDeviceId));
    }

    public SyncDevice fetchByPrimaryKey(long syncDeviceId) {
        return (SyncDevice)this.fetchByPrimaryKey(Long.valueOf(syncDeviceId));
    }

    public List<SyncDevice> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<SyncDevice> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<SyncDevice> findAll(int start, int end, OrderByComparator<SyncDevice> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<SyncDevice> findAll(int start, int end, OrderByComparator<SyncDevice> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_SYNCDEVICE);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_SYNCDEVICE;
                sql = sql.concat(" ORDER BY syncDevice.syncDeviceId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (SyncDevice syncDevice : this.findAll()) {
            this.remove((BaseModel)syncDevice);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_SYNCDEVICE);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "syncDeviceId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_SYNCDEVICE;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return SyncDeviceModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        SyncDeviceModelImpl.setEntityCacheEnabled(this.entityCacheEnabled);
        SyncDeviceModelImpl.setFinderCacheEnabled(this.finderCacheEnabled);
        this._finderPathWithPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, SyncDeviceImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, SyncDeviceImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByUuid = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, SyncDeviceImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, SyncDeviceImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, 8L);
        this._finderPathCountByUuid = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()});
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, SyncDeviceImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, SyncDeviceImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, 9L);
        this._finderPathCountByUuid_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByUserId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, SyncDeviceImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUserId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUserId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, SyncDeviceImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUserId", new String[]{Long.class.getName()}, 2L);
        this._finderPathCountByUserId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUserId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByC_U = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, SyncDeviceImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_U", new String[]{Long.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithPaginationCountByC_U = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByC_U", new String[]{Long.class.getName(), String.class.getName()});
    }

    @Deactivate
    public void deactivate() {
        this.entityCache.removeCache(SyncDeviceImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.sync.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        this._columnBitmaskEnabled = GetterUtil.getBoolean((String)configuration.get("value.object.column.bitmask.enabled.com.liferay.sync.model.SyncDevice"), (boolean)true);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.sync.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.sync.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    static {
        try {
            Class.forName(SyncPersistenceConstants.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExceptionInInitializerError(classNotFoundException);
        }
    }
}

