/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.service.impl;

import com.liferay.document.library.kernel.exception.DuplicateFileEntryException;
import com.liferay.document.library.kernel.exception.DuplicateFolderNameException;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.sync.model.DLSyncEvent;
import com.liferay.document.library.sync.service.DLSyncEventLocalService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.jsonwebservice.NoSuchJSONWebServiceException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.GroupNameComparator;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactory;
import com.liferay.portal.theme.ThemeDisplayFactory;
import com.liferay.sync.internal.configuration.SyncServiceConfigurationValues;
import com.liferay.sync.internal.util.JSONWebServiceActionParametersMap;
import com.liferay.sync.internal.util.SyncContext;
import com.liferay.sync.internal.util.SyncDLObjectUpdate;
import com.liferay.sync.internal.util.SyncDeviceThreadLocal;
import com.liferay.sync.model.SyncDLObject;
import com.liferay.sync.model.SyncDevice;
import com.liferay.sync.service.SyncDLFileVersionDiffLocalService;
import com.liferay.sync.service.base.SyncDLObjectServiceBaseImpl;
import com.liferay.sync.util.SyncHelper;
import com.liferay.sync.util.comparator.SyncDLObjectModifiedTimeComparator;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jodd.bean.BeanUtil;
import jodd.util.NameValue;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=sync", "json.web.service.context.path=SyncDLObject"}, service={AopService.class})
public class SyncDLObjectServiceImpl
extends SyncDLObjectServiceBaseImpl {
    private static final boolean _PERMISSIONS_VIEW_DYNAMIC_INHERITANCE = GetterUtil.getBoolean((String)PropsUtil.get((String)"permissions.view.dynamic.inheritance"));
    private static final int _SQL_DATA_MAX_PARAMETERS = GetterUtil.getInteger((String)PropsUtil.get((String)"sql.data.max.parameters"));
    private static final Log _log = LogFactoryUtil.getLog(SyncDLObjectServiceImpl.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DLSyncEventLocalService _dlSyncEventLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SyncDLFileVersionDiffLocalService _syncDLFileVersionDiffLocalService;
    @Reference
    private SyncHelper _syncHelper;
    @Reference
    private ZipReaderFactory _zipReaderFactory;

    public SyncDLObject addFileEntry(long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, String checksum, ServiceContext serviceContext) throws PortalException {
        try {
            ModelPermissions modelPermissions;
            Group group = this.groupLocalService.getGroup(repositoryId);
            this._syncHelper.checkSyncEnabled(group.getGroupId());
            this.checkFolder(folderId);
            if (!group.isUser() && ((modelPermissions = serviceContext.getModelPermissions()) == null || ArrayUtil.isEmpty((Object[])modelPermissions.getActionIds("PLACEHOLDER_DEFAULT_GROUP_ROLE")))) {
                this._syncHelper.setFilePermissions(group, false, serviceContext);
            }
            serviceContext.setCommand("add");
            this.populateServiceContext(serviceContext, group.getGroupId());
            FileEntry fileEntry = this.dlAppService.addFileEntry(repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
            return this.toSyncDLObject(fileEntry, "add", checksum);
        }
        catch (PortalException portalException) {
            if (portalException instanceof DuplicateFileEntryException && GetterUtil.getBoolean((Object)serviceContext.getAttribute("overwrite"))) {
                FileEntry fileEntry = this.dlAppService.getFileEntry(repositoryId, folderId, title);
                return this.updateFileEntry(fileEntry.getFileEntryId(), sourceFileName, mimeType, title, description, changeLog, false, file, checksum, serviceContext);
            }
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public SyncDLObject addFolder(long repositoryId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        try {
            ModelPermissions modelPermissions;
            Group group = this.groupLocalService.getGroup(repositoryId);
            this._syncHelper.checkSyncEnabled(group.getGroupId());
            this.checkFolder(parentFolderId);
            if (!group.isUser() && ((modelPermissions = serviceContext.getModelPermissions()) == null || ArrayUtil.isEmpty((Object[])modelPermissions.getActionIds("PLACEHOLDER_DEFAULT_GROUP_ROLE")))) {
                this._syncHelper.setFilePermissions(group, true, serviceContext);
            }
            Folder folder = this.dlAppService.addFolder(repositoryId, parentFolderId, name, description, serviceContext);
            return this.toSyncDLObject(folder, "add");
        }
        catch (PortalException portalException) {
            if (portalException instanceof DuplicateFolderNameException && GetterUtil.getBoolean((Object)serviceContext.getAttribute("overwrite"))) {
                Folder folder = this.dlAppService.getFolder(repositoryId, parentFolderId, name);
                return this.updateFolder(folder.getFolderId(), name, description, serviceContext);
            }
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public SyncDLObject cancelCheckOut(long fileEntryId) throws PortalException {
        try {
            FileEntry fileEntry = this.dlAppLocalService.getFileEntry(fileEntryId);
            this._syncHelper.checkSyncEnabled(fileEntry.getGroupId());
            this.checkFileEntry(fileEntry);
            this.dlAppService.cancelCheckOut(fileEntryId);
            fileEntry = this.dlAppLocalService.getFileEntry(fileEntryId);
            return this.toSyncDLObject(fileEntry, "cancelCheckOut");
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public SyncDLObject checkInFileEntry(long fileEntryId, boolean majorVersion, String changeLog, ServiceContext serviceContext) throws PortalException {
        try {
            FileEntry fileEntry = this.dlAppLocalService.getFileEntry(fileEntryId);
            this._syncHelper.checkSyncEnabled(fileEntry.getGroupId());
            this.checkFileEntry(fileEntry);
            this.dlAppService.checkInFileEntry(fileEntryId, DLVersionNumberIncrease.fromMajorVersion((boolean)majorVersion), changeLog, serviceContext);
            fileEntry = this.dlAppLocalService.getFileEntry(fileEntryId);
            return this.toSyncDLObject(fileEntry, "checkIn");
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public SyncDLObject checkOutFileEntry(long fileEntryId, ServiceContext serviceContext) throws PortalException {
        try {
            FileEntry fileEntry = this.dlAppLocalService.getFileEntry(fileEntryId);
            this._syncHelper.checkSyncEnabled(fileEntry.getGroupId());
            this.checkFileEntry(fileEntry);
            this.dlAppService.checkOutFileEntry(fileEntryId, serviceContext);
            fileEntry = this.dlAppLocalService.getFileEntry(fileEntryId);
            return this.toSyncDLObject(fileEntry, "checkOut");
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public SyncDLObject checkOutFileEntry(long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException {
        try {
            FileEntry fileEntry = this.dlAppLocalService.getFileEntry(fileEntryId);
            this._syncHelper.checkSyncEnabled(fileEntry.getGroupId());
            this.checkFileEntry(fileEntry);
            fileEntry = this.dlAppService.checkOutFileEntry(fileEntryId, owner, expirationTime, serviceContext);
            return this.toSyncDLObject(fileEntry, "checkOut");
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public SyncDLObject copyFileEntry(long sourceFileEntryId, long repositoryId, long folderId, String sourceFileName, String title, ServiceContext serviceContext) throws PortalException {
        try {
            ModelPermissions modelPermissions;
            Group group = this.groupLocalService.getGroup(repositoryId);
            this._syncHelper.checkSyncEnabled(group.getGroupId());
            this.checkFolder(folderId);
            FileEntry sourceFileEntry = this.dlAppLocalService.getFileEntry(sourceFileEntryId);
            SyncDLObject sourceSyncDLObject = this.syncDLObjectLocalService.fetchSyncDLObject("file", sourceFileEntryId);
            FileVersion fileVersion = sourceFileEntry.getLatestFileVersion();
            if (!group.isUser() && ((modelPermissions = serviceContext.getModelPermissions()) == null || ArrayUtil.isEmpty((Object[])modelPermissions.getActionIds("PLACEHOLDER_DEFAULT_GROUP_ROLE")))) {
                this._syncHelper.setFilePermissions(group, false, serviceContext);
            }
            serviceContext.setCommand("add");
            this.populateServiceContext(serviceContext, group.getGroupId());
            FileEntry fileEntry = this.dlAppService.addFileEntry(repositoryId, folderId, sourceFileName, sourceFileEntry.getMimeType(), title, null, null, fileVersion.getContentStream(false), sourceFileEntry.getSize(), serviceContext);
            return this.toSyncDLObject(fileEntry, "add", sourceSyncDLObject.getChecksum());
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public List<SyncDLObject> getAllFolderSyncDLObjects(long repositoryId) throws PortalException {
        try {
            this._syncHelper.checkSyncEnabled(repositoryId);
            this.repositoryService.checkRepository(repositoryId);
            List syncDLObjects = this.syncDLObjectFinder.findByModifiedTime(-1L, repositoryId, 0L, "folder", -1, -1);
            return this.checkSyncDLObjects(syncDLObjects, repositoryId, 0L);
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public SyncDLObject getFileEntrySyncDLObject(long repositoryId, long folderId, String title) throws PortalException {
        try {
            this._syncHelper.checkSyncEnabled(repositoryId);
            FileEntry fileEntry = this.dlAppService.getFileEntry(repositoryId, folderId, title);
            return this.toSyncDLObject(fileEntry, "get");
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public List<SyncDLObject> getFileEntrySyncDLObjects(long repositoryId, long folderId) throws PortalException {
        try {
            this._syncHelper.checkSyncEnabled(repositoryId);
            List fileEntries = this.dlAppService.getFileEntries(repositoryId, folderId);
            ArrayList<SyncDLObject> syncDLObjects = new ArrayList<SyncDLObject>(fileEntries.size());
            for (FileEntry fileEntry : fileEntries) {
                SyncDLObject syncDLObject = this.toSyncDLObject(fileEntry, "get");
                syncDLObjects.add(syncDLObject);
            }
            return syncDLObjects;
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public SyncDLObject getFolderSyncDLObject(long folderId) throws PortalException {
        try {
            Folder folder = this.dlAppLocalService.getFolder(folderId);
            this._syncHelper.checkSyncEnabled(folder.getGroupId());
            folder = this.dlAppService.getFolder(folderId);
            if (!this._syncHelper.isSupportedFolder(folder)) {
                return null;
            }
            return this.toSyncDLObject(folder, "get");
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public SyncDLObject getFolderSyncDLObject(long repositoryId, long parentFolderId, String name) throws PortalException {
        try {
            this._syncHelper.checkSyncEnabled(repositoryId);
            Folder folder = this.dlAppService.getFolder(repositoryId, parentFolderId, name);
            if (!this._syncHelper.isSupportedFolder(folder)) {
                return null;
            }
            return this.toSyncDLObject(folder, "get");
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public List<SyncDLObject> getFolderSyncDLObjects(long repositoryId, long parentFolderId) throws PortalException {
        try {
            this._syncHelper.checkSyncEnabled(repositoryId);
            List folders = this.dlAppService.getFolders(repositoryId, parentFolderId);
            ArrayList<SyncDLObject> syncDLObjects = new ArrayList<SyncDLObject>(folders.size());
            for (Folder folder : folders) {
                if (!this._syncHelper.isSupportedFolder(folder)) continue;
                SyncDLObject syncDLObject = this.toSyncDLObject(folder, "get");
                syncDLObjects.add(syncDLObject);
            }
            return syncDLObjects;
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public Group getGroup(long groupId) throws PortalException {
        try {
            this._syncHelper.checkSyncEnabled(groupId);
            return this.groupService.getGroup(groupId);
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public long getLatestModifiedTime() throws PortalException {
        try {
            this._syncHelper.checkSyncEnabled(0L);
            return this.syncDLObjectLocalService.getLatestModifiedTime();
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    @AccessControlled(guestAccessEnabled=true)
    public Object getSyncContext() throws PortalException {
        try {
            this._syncHelper.checkSyncEnabled(0L);
            User user = this.getGuestOrUser();
            SyncContext syncContext = new SyncContext();
            String authType = PrefsPropsUtil.getString((long)CompanyThreadLocal.getCompanyId(), (String)"company.security.auth.type", (String)PropsUtil.get((String)"company.security.auth.type"));
            syncContext.setAuthType(authType);
            boolean oAuthEnabled = PrefsPropsUtil.getBoolean((long)user.getCompanyId(), (String)"sync.oauth.enabled");
            if (oAuthEnabled) {
                String oAuthConsumerKey = PrefsPropsUtil.getString((long)user.getCompanyId(), (String)"sync.oauth.consumer.key");
                syncContext.setOAuthConsumerKey(oAuthConsumerKey);
                String oAuthConsumerSecret = PrefsPropsUtil.getString((long)user.getCompanyId(), (String)"sync.oauth.consumer.secret");
                syncContext.setOAuthConsumerSecret(oAuthConsumerSecret);
                syncContext.setOAuthEnabled(true);
            }
            syncContext.setPortletPreferencesMap(this.getPortletPreferencesMap());
            Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
            syncContext.setPluginVersion(String.valueOf(bundle.getVersion()));
            if (!user.isDefaultUser()) {
                boolean lanEnabled = PrefsPropsUtil.getBoolean((long)user.getCompanyId(), (String)"sync.lan.enabled", (boolean)SyncServiceConfigurationValues.SYNC_LAN_ENABLED);
                if (lanEnabled) {
                    String lanCertificate = PrefsPropsUtil.getString((long)user.getCompanyId(), (String)"sync.lan.certificate");
                    syncContext.setLanCertificate(lanCertificate);
                    syncContext.setLanEnabled(true);
                    String lanKey = PrefsPropsUtil.getString((long)user.getCompanyId(), (String)"sync.lan.key");
                    syncContext.setLanKey(lanKey);
                    String lanServerUuid = PrefsPropsUtil.getString((long)user.getCompanyId(), (String)"sync.lan.server.uuid");
                    syncContext.setLanServerUuid(lanServerUuid);
                }
                syncContext.setPortalBuildNumber(ReleaseInfo.getBuildNumber());
                syncContext.setUser(user);
                if (!SyncDLObjectServiceImpl.syncDeviceSupports(1)) {
                    syncContext.setUserSitesGroups(this.getUserSitesGroups());
                }
            }
            return syncContext;
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public String getSyncDLObjectUpdate(long repositoryId, long lastAccessTime, int max) throws PortalException {
        return this.getSyncDLObjectUpdate(repositoryId, lastAccessTime, max, true);
    }

    public String getSyncDLObjectUpdate(long repositoryId, long lastAccessTime, int max, boolean retrieveFromCache) throws PortalException {
        try {
            this._syncHelper.checkSyncEnabled(repositoryId);
            this.repositoryService.checkRepository(repositoryId);
            String[] events = null;
            events = retrieveFromCache ? new String[]{} : new String[]{"delete", "trash"};
            int count = this.syncDLObjectPersistence.countByM_R_NotE(lastAccessTime, repositoryId, events);
            if (count == 0) {
                SyncDLObjectUpdate syncDLObjectUpdate = SyncDLObjectServiceImpl.getSyncDLObjectUpdate(Collections.emptyList(), 0, lastAccessTime, lastAccessTime);
                return syncDLObjectUpdate.toString();
            }
            int start = 0;
            int end = 0;
            if (max == -1) {
                start = -1;
                end = -1;
            } else {
                end = max == 0 ? SyncServiceConfigurationValues.SYNC_PAGINATION_DELTA : max;
            }
            List syncDLObjects = null;
            syncDLObjects = retrieveFromCache ? this.syncDLObjectPersistence.findByM_R_NotE(lastAccessTime, repositoryId, events, start, end, (OrderByComparator)new SyncDLObjectModifiedTimeComparator()) : this.syncDLObjectFinder.findByModifiedTime(lastAccessTime, repositoryId, 0L, null, start, end);
            SyncDLObject syncDLObject = (SyncDLObject)syncDLObjects.get(syncDLObjects.size() - 1);
            SyncDLObjectUpdate syncDLObjectUpdate = SyncDLObjectServiceImpl.getSyncDLObjectUpdate(this.checkSyncDLObjects(syncDLObjects, repositoryId, lastAccessTime), count, syncDLObject.getModifiedTime(), lastAccessTime);
            return syncDLObjectUpdate.toString();
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public String getSyncDLObjectUpdate(long repositoryId, long parentFolderId, long lastAccessTime) throws PortalException {
        try {
            this._syncHelper.checkSyncEnabled(repositoryId);
            this.repositoryService.checkRepository(repositoryId);
            List syncDLObjects = this.syncDLObjectFinder.findByModifiedTime(lastAccessTime, repositoryId, parentFolderId, null, -1, -1);
            SyncDLObject syncDLObject = (SyncDLObject)syncDLObjects.get(syncDLObjects.size() - 1);
            SyncDLObjectUpdate syncDLObjectUpdate = SyncDLObjectServiceImpl.getSyncDLObjectUpdate(this.checkSyncDLObjects(syncDLObjects, repositoryId, lastAccessTime), syncDLObjects.size(), syncDLObject.getModifiedTime(), lastAccessTime);
            return syncDLObjectUpdate.toString();
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public List<Group> getUserSitesGroups() throws PortalException {
        try {
            Group companyGroup;
            this._syncHelper.checkSyncEnabled(0L);
            User user = this.getUser();
            ArrayList<Object> groups = new ArrayList<Object>();
            List userSiteGroups = this.groupLocalService.search(user.getCompanyId(), null, LinkedHashMapBuilder.put((Object)"active", (Object)true).put((Object)"usersGroups", (Object)user.getUserId()).build(), -1, -1);
            for (Object userSiteGroup : userSiteGroups) {
                if (!this._syncHelper.isSyncEnabled((Group)userSiteGroup)) continue;
                userSiteGroup.setName(userSiteGroup.getDescriptiveName());
                groups.add(userSiteGroup);
            }
            List organizations = this.organizationLocalService.getOrganizations(user.getUserId(), -1, -1, null);
            for (Organization organization : organizations) {
                Group userOrganizationGroup = organization.getGroup();
                if (this._syncHelper.isSyncEnabled(userOrganizationGroup)) {
                    userOrganizationGroup.setName(userOrganizationGroup.getDescriptiveName());
                    groups.add(userOrganizationGroup);
                }
                if (GetterUtil.getBoolean((String)PropsUtil.get((String)"organizations.membership.strict"))) continue;
                for (Organization ancestorOrganization : organization.getAncestors()) {
                    Group userAncestorOrganizationGroup = ancestorOrganization.getGroup();
                    if (!this._syncHelper.isSyncEnabled(userAncestorOrganizationGroup)) continue;
                    userAncestorOrganizationGroup.setName(userAncestorOrganizationGroup.getDescriptiveName());
                    groups.add(userAncestorOrganizationGroup);
                }
            }
            if (PrefsPropsUtil.getBoolean((long)user.getCompanyId(), (String)"sync.allow.user.personal.sites", (boolean)SyncServiceConfigurationValues.SYNC_ALLOW_USER_PERSONAL_SITES)) {
                Group userGroup = user.getGroup();
                userGroup.setName(user.getScreenName());
                groups.add(userGroup);
            }
            if (this._syncHelper.isSyncEnabled(companyGroup = this.groupLocalService.getCompanyGroup(user.getCompanyId()))) {
                companyGroup.setName(companyGroup.getDescriptiveName());
                groups.add(companyGroup);
            }
            Collections.sort(groups, new GroupNameComparator());
            return ListUtil.unique(groups);
        }
        catch (PortalException portalException) {
            Class<?> clazz = ((Object)((Object)portalException)).getClass();
            throw new PortalException(clazz.getName(), (Throwable)portalException);
        }
    }

    public SyncDLObject moveFileEntry(long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        try {
            FileEntry fileEntry = this.dlAppLocalService.getFileEntry(fileEntryId);
            this._syncHelper.checkSyncEnabled(fileEntry.getGroupId());
            this.checkFileEntry(fileEntry);
            fileEntry = this.dlAppService.moveFileEntry(fileEntryId, newFolderId, serviceContext);
            return this.toSyncDLObject(fileEntry, "move");
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public SyncDLObject moveFileEntryToTrash(long fileEntryId) throws PortalException {
        try {
            FileEntry fileEntry = this.dlAppLocalService.getFileEntry(fileEntryId);
            this._syncHelper.checkSyncEnabled(fileEntry.getGroupId());
            this.checkFileEntry(fileEntry);
            fileEntry = this.dlTrashService.moveFileEntryToTrash(fileEntryId);
            return this.toSyncDLObject(fileEntry, "trash");
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public SyncDLObject moveFolder(long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        try {
            Folder folder = this.dlAppLocalService.getFolder(folderId);
            this._syncHelper.checkSyncEnabled(folder.getGroupId());
            this.checkFolder(folder);
            folder = this.dlAppService.moveFolder(folderId, parentFolderId, serviceContext);
            return this.toSyncDLObject(folder, "move");
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public SyncDLObject moveFolderToTrash(long folderId) throws PortalException {
        try {
            Folder folder = this.dlAppLocalService.getFolder(folderId);
            this._syncHelper.checkSyncEnabled(folder.getGroupId());
            this.checkFolder(folderId);
            folder = this.dlTrashService.moveFolderToTrash(folderId);
            return this.toSyncDLObject(folder, "trash");
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public SyncDLObject patchFileEntry(long fileEntryId, long sourceVersionId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File deltaFile, String checksum, ServiceContext serviceContext) throws PortalException {
        SyncDLObject syncDLObject;
        File patchedFile = null;
        try {
            FileEntry fileEntry = this.dlAppLocalService.getFileEntry(fileEntryId);
            this._syncHelper.checkSyncEnabled(fileEntry.getGroupId());
            this.checkFileEntry(fileEntry);
            DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getDLFileVersion(sourceVersionId);
            File sourceFile = this.dlFileEntryLocalService.getFile(fileEntryId, dlFileVersion.getVersion(), false);
            patchedFile = FileUtil.createTempFile();
            this._syncHelper.patchFile(sourceFile, deltaFile, patchedFile);
            SyncDLObject syncDLObject2 = this.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, patchedFile, checksum, serviceContext);
            if (SyncServiceConfigurationValues.SYNC_FILE_DIFF_CACHE_ENABLED && sourceVersionId != syncDLObject2.getVersionId()) {
                DLFileVersion targetDLFileVersion = this.dlFileVersionLocalService.getFileVersion(syncDLObject2.getVersionId());
                this._syncDLFileVersionDiffLocalService.addSyncDLFileVersionDiff(fileEntryId, sourceVersionId, targetDLFileVersion.getFileVersionId(), deltaFile);
            }
            syncDLObject = syncDLObject2;
        }
        catch (PortalException portalException) {
            try {
                throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
            }
            catch (Throwable throwable) {
                FileUtil.delete(patchedFile);
                throw throwable;
            }
        }
        FileUtil.delete((File)patchedFile);
        return syncDLObject;
    }

    public SyncDLObject restoreFileEntryFromTrash(long fileEntryId) throws PortalException {
        try {
            FileEntry fileEntry = this.dlAppLocalService.getFileEntry(fileEntryId);
            this._syncHelper.checkSyncEnabled(fileEntry.getGroupId());
            this.dlTrashService.restoreFileEntryFromTrash(fileEntryId);
            fileEntry = this.dlAppLocalService.getFileEntry(fileEntryId);
            return this.toSyncDLObject(fileEntry, "restore");
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public SyncDLObject restoreFolderFromTrash(long folderId) throws PortalException {
        try {
            Folder folder = this.dlAppLocalService.getFolder(folderId);
            this._syncHelper.checkSyncEnabled(folder.getGroupId());
            this.dlTrashService.restoreFolderFromTrash(folderId);
            folder = this.dlAppLocalService.getFolder(folderId);
            return this.toSyncDLObject(folder, "restore");
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    @Transactional(enabled=false)
    public Map<String, Object> updateFileEntries(File zipFile) throws PortalException {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        try (ZipReader zipReader = null;){
            this._syncHelper.checkSyncEnabled(0L);
            zipReader = this._zipReaderFactory.getZipReader(zipFile);
            String manifest = zipReader.getEntryAsString("/manifest.json");
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)manifest);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                JSONWebServiceActionParametersMap jsonWebServiceActionParametersMap = (JSONWebServiceActionParametersMap)JSONFactoryUtil.looseDeserialize((String)jsonObject.toString(), JSONWebServiceActionParametersMap.class);
                String zipFileId = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"zipFileId");
                try {
                    responseMap.put(zipFileId, this.updateFileEntries(zipReader, zipFileId, jsonWebServiceActionParametersMap));
                    continue;
                }
                catch (Exception exception) {
                    String message = exception.getMessage();
                    if (message == null) {
                        _log.error((Object)exception, (Throwable)exception);
                        message = exception.toString();
                    }
                    if (!message.startsWith("\"") && !message.endsWith("\"")) {
                        message = StringUtil.quote((String)message, (String)"\"");
                    }
                    String json = "{\"exception\": " + message + "}";
                    responseMap.put(zipFileId, json);
                }
            }
        }
        return responseMap;
    }

    public SyncDLObject updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, String checksum, ServiceContext serviceContext) throws PortalException {
        try {
            FileEntry fileEntry = this.dlAppLocalService.getFileEntry(fileEntryId);
            this._syncHelper.checkSyncEnabled(fileEntry.getGroupId());
            this.checkFileEntry(fileEntry);
            serviceContext.setCommand("update");
            this.populateServiceContext(serviceContext, fileEntry.getGroupId());
            fileEntry = this.dlAppService.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, description, changeLog, DLVersionNumberIncrease.fromMajorVersion((boolean)majorVersion), file, serviceContext);
            return this.toSyncDLObject(fileEntry, "update", checksum);
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    public SyncDLObject updateFolder(long folderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        try {
            Folder folder = this.dlAppLocalService.getFolder(folderId);
            this._syncHelper.checkSyncEnabled(folder.getGroupId());
            this.checkFolder(folder);
            folder = this.dlAppService.updateFolder(folderId, name, description, serviceContext);
            return this.toSyncDLObject(folder, "update");
        }
        catch (PortalException portalException) {
            throw new PortalException(this._syncHelper.buildExceptionMessage((Throwable)portalException), (Throwable)portalException);
        }
    }

    protected static SyncDLObjectUpdate getSyncDLObjectUpdate(List<SyncDLObject> syncDLObjects, int resultsTotal, long lastAccessTime, long previousLastAccessTime) {
        HashMap<String, Long> settingsModifiedTimes = new HashMap<String, Long>();
        long syncContextModifiedTime = PrefsPropsUtil.getLong((long)CompanyThreadLocal.getCompanyId(), (String)"sync.context.modified.time");
        if (syncContextModifiedTime != 0L && syncContextModifiedTime > previousLastAccessTime) {
            settingsModifiedTimes.put("sync.context.modified.time", syncContextModifiedTime);
        }
        return new SyncDLObjectUpdate(syncDLObjects, resultsTotal, lastAccessTime, settingsModifiedTimes);
    }

    protected static boolean syncDeviceSupports(int featureSet) {
        SyncDevice syncDevice = SyncDeviceThreadLocal.getSyncDevice();
        if (syncDevice == null) {
            return false;
        }
        return syncDevice.supports(featureSet);
    }

    protected void checkFileEntry(FileEntry fileEntry) throws PortalException {
        if (fileEntry.isInTrash()) {
            throw new NoSuchFileEntryException();
        }
    }

    protected void checkFolder(Folder folder) throws PortalException {
        if (folder.getModel() instanceof DLFolder) {
            DLFolder dlFolder = (DLFolder)folder.getModel();
            if (dlFolder.isInTrash()) {
                throw new NoSuchFolderException();
            }
            return;
        }
        throw new PortalException("Folder must be an instance of DLFolder");
    }

    protected void checkFolder(long folderId) throws PortalException {
        if (folderId == 0L) {
            return;
        }
        this.checkFolder(this.dlAppService.getFolder(folderId));
    }

    protected SyncDLObject checkModifiedTime(SyncDLObject syncDLObject, long typePK) {
        DynamicQuery dynamicQuery = this._dlSyncEventLocalService.dynamicQuery();
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"typePK", (Object)typePK));
        List dlSyncEvents = this._dlSyncEventLocalService.dynamicQuery(dynamicQuery);
        if (dlSyncEvents.isEmpty()) {
            return syncDLObject;
        }
        DLSyncEvent dlSyncEvent = (DLSyncEvent)dlSyncEvents.get(0);
        syncDLObject.setModifiedTime(dlSyncEvent.getModifiedTime());
        return syncDLObject;
    }

    protected List<SyncDLObject> checkSyncDLObjects(List<SyncDLObject> syncDLObjects, long repositoryId, long lastAccessTime) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (permissionChecker.isGroupAdmin(repositoryId)) {
            return syncDLObjects;
        }
        boolean hasFileModelPermission = this.hasModelPermission(repositoryId, DLFileEntryConstants.getClassName());
        boolean hasFolderModelPermission = this.hasModelPermission(repositoryId, DLFolderConstants.getClassName());
        if (hasFileModelPermission && hasFolderModelPermission) {
            return syncDLObjects;
        }
        HashSet<Long> typePKs = new HashSet<Long>();
        for (SyncDLObject syncDLObject : syncDLObjects) {
            typePKs.add(syncDLObject.getTypePK());
            if (hasFolderModelPermission || !_PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) continue;
            long[] parentFolderIds = StringUtil.split((String)syncDLObject.getTreePath(), (String)"/", (long)0L);
            for (long parentFolderId : parentFolderIds) {
                if (parentFolderId <= 0L) continue;
                typePKs.add(parentFolderId);
            }
        }
        Set checkedTypePKs = SetUtil.fromList(this.checkTypePKs(repositoryId, permissionChecker.getUserId(), new ArrayList<Long>(typePKs)));
        ArrayList<SyncDLObject> checkedSyncDLObjects = new ArrayList<SyncDLObject>();
        Date lastAccessDate = new Date(lastAccessTime);
        Object object = syncDLObjects.iterator();
        while (object.hasNext()) {
            SyncDLObject syncDLObject = (SyncDLObject)object.next();
            String event = syncDLObject.getEvent();
            if (event.equals("delete") || event.equals("trash") || this.hasPermission(checkedTypePKs, syncDLObject, hasFileModelPermission, hasFolderModelPermission)) {
                checkedSyncDLObjects.add(syncDLObject);
                continue;
            }
            Date lastPermissionChangeDate = syncDLObject.getLastPermissionChangeDate();
            if (lastPermissionChangeDate == null || !lastPermissionChangeDate.after(lastAccessDate)) continue;
            syncDLObject.setEvent("delete");
            checkedSyncDLObjects.add(syncDLObject);
        }
        return checkedSyncDLObjects;
    }

    protected List<Long> checkTypePKs(long repositoryId, long userId, List<Long> typePKs) {
        if (typePKs.size() <= _SQL_DATA_MAX_PARAMETERS) {
            return this.syncDLObjectFinder.filterFindByR_U_T(repositoryId, userId, ArrayUtil.toLongArray(typePKs));
        }
        List<Long> sublistTypePKs = typePKs.subList(0, _SQL_DATA_MAX_PARAMETERS);
        List checkedTypePKs = this.syncDLObjectFinder.filterFindByR_U_T(repositoryId, userId, ArrayUtil.toLongArray(sublistTypePKs));
        sublistTypePKs.clear();
        checkedTypePKs.addAll(this.checkTypePKs(repositoryId, userId, typePKs));
        return checkedTypePKs;
    }

    protected Map<String, String> getPortletPreferencesMap() throws PortalException {
        User user = this.getUser();
        int batchFileMaxSize = PrefsPropsUtil.getInteger((long)user.getCompanyId(), (String)"sync.client.batch.file.max.size", (int)SyncServiceConfigurationValues.SYNC_CLIENT_BATCH_FILE_MAX_SIZE);
        boolean forceSecurityMode = PrefsPropsUtil.getBoolean((long)user.getCompanyId(), (String)"sync.client.force.security.mode", (boolean)SyncServiceConfigurationValues.SYNC_CLIENT_FORCE_SECURITY_MODE);
        int maxConnections = PrefsPropsUtil.getInteger((long)user.getCompanyId(), (String)"sync.client.max.connections", (int)SyncServiceConfigurationValues.SYNC_CLIENT_MAX_CONNECTIONS);
        int maxDownloadRate = PrefsPropsUtil.getInteger((long)user.getCompanyId(), (String)"sync.client.max.download.rate", (int)SyncServiceConfigurationValues.SYNC_CLIENT_MAX_DOWNLOAD_RATE);
        int maxUploadRate = PrefsPropsUtil.getInteger((long)user.getCompanyId(), (String)"sync.client.max.upload.rate", (int)SyncServiceConfigurationValues.SYNC_CLIENT_MAX_UPLOAD_RATE);
        int pollInterval = PrefsPropsUtil.getInteger((long)user.getCompanyId(), (String)"sync.client.poll.interval", (int)SyncServiceConfigurationValues.SYNC_CLIENT_POLL_INTERVAL);
        return HashMapBuilder.put((Object)"sync.client.authentication.retry.interval", (Object)String.valueOf(SyncServiceConfigurationValues.SYNC_CLIENT_AUTHENTICATION_RETRY_INTERVAL)).put((Object)"sync.client.batch.file.max.size", (Object)String.valueOf(batchFileMaxSize)).put((Object)"sync.client.force.security.mode", (Object)String.valueOf(forceSecurityMode)).put((Object)"sync.client.max.connections", (Object)String.valueOf(maxConnections)).put((Object)"sync.client.max.download.rate", (Object)String.valueOf(maxDownloadRate)).put((Object)"sync.client.max.upload.rate", (Object)String.valueOf(maxUploadRate)).put((Object)"sync.client.poll.interval", (Object)String.valueOf(pollInterval)).build();
    }

    protected boolean hasModelPermission(long groupId, String name) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        long[] roleIds = permissionChecker.getRoleIds(permissionChecker.getUserId(), groupId);
        if (roleIds.length == 0) {
            return false;
        }
        return this.resourcePermissionLocalService.hasResourcePermission(permissionChecker.getCompanyId(), name, 1, String.valueOf(permissionChecker.getCompanyId()), roleIds, "VIEW") || this.resourcePermissionLocalService.hasResourcePermission(permissionChecker.getCompanyId(), name, 3, String.valueOf(0L), roleIds, "VIEW") || this.resourcePermissionLocalService.hasResourcePermission(permissionChecker.getCompanyId(), name, 2, String.valueOf(groupId), roleIds, "VIEW");
    }

    protected boolean hasPermission(Set<Long> checkedTypePKs, SyncDLObject syncDLObject, boolean hasFileModelPermission, boolean hasFolderModelPermission) {
        String type = syncDLObject.getType();
        if (!(type.equals("file") && hasFileModelPermission || type.equals("folder") && hasFolderModelPermission || checkedTypePKs.contains(syncDLObject.getTypePK()))) {
            return false;
        }
        if (!hasFolderModelPermission && _PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
            long[] parentFolderIds;
            for (long parentFolderId : parentFolderIds = StringUtil.split((String)syncDLObject.getTreePath(), (String)"/", (long)0L)) {
                if (parentFolderId <= 0L || checkedTypePKs.contains(parentFolderId)) continue;
                return false;
            }
        }
        return true;
    }

    protected void populateServiceContext(ServiceContext serviceContext, long groupId) throws PortalException {
        ServiceContext serviceContextThreadLocal = ServiceContextThreadLocal.getServiceContext();
        HttpServletRequest httpServletRequest = serviceContextThreadLocal.getRequest();
        if (httpServletRequest == null) {
            return;
        }
        long companyId = CompanyThreadLocal.getCompanyId();
        serviceContext.setCompanyId(companyId);
        serviceContext.setPlid(0L);
        serviceContext.setRequest(httpServletRequest);
        ThemeDisplay themeDisplay = ThemeDisplayFactory.create();
        themeDisplay.setCompany(this._companyLocalService.getCompany(companyId));
        themeDisplay.setPermissionChecker(this.getPermissionChecker());
        themeDisplay.setPlid(this._portal.getControlPanelPlid(companyId));
        themeDisplay.setRequest(httpServletRequest);
        themeDisplay.setScopeGroupId(groupId);
        themeDisplay.setSiteGroupId(groupId);
        httpServletRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)themeDisplay);
    }

    protected SyncDLObject toSyncDLObject(FileEntry fileEntry, String event) throws PortalException {
        return this.toSyncDLObject(fileEntry, event, null);
    }

    protected SyncDLObject toSyncDLObject(FileEntry fileEntry, String event, String checksum) throws PortalException {
        SyncDLObject syncDLObject = this._syncHelper.toSyncDLObject(fileEntry, event);
        this.checkModifiedTime(syncDLObject, fileEntry.getFileEntryId());
        if (Validator.isNotNull((String)checksum)) {
            this._syncHelper.addChecksum(syncDLObject.getModifiedTime(), fileEntry.getFileEntryId(), checksum);
        }
        String lanTokenKey = this._syncHelper.getLanTokenKey(syncDLObject.getModifiedTime(), fileEntry.getFileEntryId(), true);
        syncDLObject.setLanTokenKey(lanTokenKey);
        return syncDLObject;
    }

    protected SyncDLObject toSyncDLObject(Folder folder, String event) throws PortalException {
        SyncDLObject syncDLObject = this._syncHelper.toSyncDLObject(folder, event);
        return this.checkModifiedTime(syncDLObject, folder.getFolderId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SyncDLObject updateFileEntries(ZipReader zipReader, String zipFileId, JSONWebServiceActionParametersMap jsonWebServiceActionParametersMap) throws Exception {
        String urlPath;
        ServiceContext serviceContext = new ServiceContext();
        ServiceContext serviceContextThreadLocal = ServiceContextThreadLocal.getServiceContext();
        serviceContext.setRequest(serviceContextThreadLocal.getRequest());
        List<NameValue<String, Object>> innerParameters = jsonWebServiceActionParametersMap.getInnerParameters("serviceContext");
        if (innerParameters != null) {
            for (NameValue<String, Object> innerParameter : innerParameters) {
                try {
                    BeanUtil.setProperty((Object)serviceContext, (String)((String)innerParameter.getName()), (Object)innerParameter.getValue());
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
        if ((urlPath = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"urlPath")).endsWith("/add-file-entry")) {
            long repositoryId = MapUtil.getLong((Map)jsonWebServiceActionParametersMap, (String)"repositoryId");
            long folderId = MapUtil.getLong((Map)jsonWebServiceActionParametersMap, (String)"folderId");
            String sourceFileName = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"sourceFileName");
            String mimeType = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"mimeType");
            String title = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"title");
            String description = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"description");
            String changeLog = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"changeLog");
            InputStream inputStream = zipReader.getEntryAsInputStream(zipFileId);
            File tempFile = null;
            try {
                tempFile = FileUtil.createTempFile((InputStream)inputStream);
                String checksum = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"checksum");
                SyncDLObject syncDLObject = this.syncDLObjectService.addFileEntry(repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, tempFile, checksum, serviceContext);
                return syncDLObject;
            }
            finally {
                FileUtil.delete((File)tempFile);
            }
        }
        if (urlPath.endsWith("/add-folder")) {
            long repositoryId = MapUtil.getLong((Map)jsonWebServiceActionParametersMap, (String)"repositoryId");
            long parentFolderId = MapUtil.getLong((Map)jsonWebServiceActionParametersMap, (String)"parentFolderId");
            String name = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"name");
            String description = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"description");
            return this.syncDLObjectService.addFolder(repositoryId, parentFolderId, name, description, serviceContext);
        }
        if (urlPath.endsWith("/copy-file-entry")) {
            long sourceFileEntryId = MapUtil.getLong((Map)jsonWebServiceActionParametersMap, (String)"sourceFileEntryId");
            long repositoryId = MapUtil.getLong((Map)jsonWebServiceActionParametersMap, (String)"repositoryId");
            long folderId = MapUtil.getLong((Map)jsonWebServiceActionParametersMap, (String)"folderId");
            String sourceFileName = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"sourceFileName");
            String title = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"title");
            return this.syncDLObjectService.copyFileEntry(sourceFileEntryId, repositoryId, folderId, sourceFileName, title, serviceContext);
        }
        if (urlPath.endsWith("/move-file-entry")) {
            long fileEntryId = MapUtil.getLong((Map)jsonWebServiceActionParametersMap, (String)"fileEntryId");
            long newFolderId = MapUtil.getLong((Map)jsonWebServiceActionParametersMap, (String)"newFolderId");
            return this.syncDLObjectService.moveFileEntry(fileEntryId, newFolderId, serviceContext);
        }
        if (urlPath.endsWith("/move-file-entry-to-trash")) {
            long fileEntryId = MapUtil.getLong((Map)jsonWebServiceActionParametersMap, (String)"fileEntryId");
            return this.syncDLObjectService.moveFileEntryToTrash(fileEntryId);
        }
        if (urlPath.endsWith("/move-folder")) {
            long folderId = MapUtil.getLong((Map)jsonWebServiceActionParametersMap, (String)"folderId");
            long parentFolderId = MapUtil.getLong((Map)jsonWebServiceActionParametersMap, (String)"parentFolderId");
            return this.syncDLObjectService.moveFolder(folderId, parentFolderId, serviceContext);
        }
        if (urlPath.endsWith("/move-folder-to-trash")) {
            long folderId = MapUtil.getLong((Map)jsonWebServiceActionParametersMap, (String)"folderId");
            return this.syncDLObjectService.moveFolderToTrash(folderId);
        }
        if (urlPath.endsWith("/patch-file-entry")) {
            long fileEntryId = MapUtil.getLong((Map)jsonWebServiceActionParametersMap, (String)"fileEntryId");
            long sourceVersionId = MapUtil.getLong((Map)jsonWebServiceActionParametersMap, (String)"sourceVersionId");
            String sourceFileName = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"sourceFileName");
            String mimeType = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"mimeType");
            String title = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"title");
            String description = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"description");
            String changeLog = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"changeLog");
            boolean majorVersion = MapUtil.getBoolean((Map)jsonWebServiceActionParametersMap, (String)"majorVersion");
            InputStream inputStream = zipReader.getEntryAsInputStream(zipFileId);
            File tempFile = null;
            try {
                tempFile = FileUtil.createTempFile((InputStream)inputStream);
                String checksum = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"checksum");
                SyncDLObject syncDLObject = this.syncDLObjectService.patchFileEntry(fileEntryId, sourceVersionId, sourceFileName, mimeType, title, description, changeLog, majorVersion, tempFile, checksum, serviceContext);
                return syncDLObject;
            }
            finally {
                FileUtil.delete((File)tempFile);
            }
        }
        if (urlPath.endsWith("/update-file-entry")) {
            SyncDLObject syncDLObject;
            long fileEntryId = MapUtil.getLong((Map)jsonWebServiceActionParametersMap, (String)"fileEntryId");
            String sourceFileName = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"sourceFileName");
            String mimeType = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"mimeType");
            String title = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"title");
            String description = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"description");
            String changeLog = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"changeLog");
            boolean majorVersion = MapUtil.getBoolean((Map)jsonWebServiceActionParametersMap, (String)"majorVersion");
            File tempFile = null;
            try {
                InputStream inputStream = zipReader.getEntryAsInputStream(zipFileId);
                if (inputStream != null) {
                    tempFile = FileUtil.createTempFile((InputStream)inputStream);
                }
                String checksum = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"checksum");
                syncDLObject = this.syncDLObjectService.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, tempFile, checksum, serviceContext);
            }
            catch (Throwable throwable) {
                FileUtil.delete(tempFile);
                throw throwable;
            }
            FileUtil.delete((File)tempFile);
            return syncDLObject;
        }
        if (urlPath.endsWith("/update-folder")) {
            long folderId = MapUtil.getLong((Map)jsonWebServiceActionParametersMap, (String)"folderId");
            String name = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"name");
            String description = MapUtil.getString((Map)jsonWebServiceActionParametersMap, (String)"description");
            return this.syncDLObjectService.updateFolder(folderId, name, description, serviceContext);
        }
        throw new NoSuchJSONWebServiceException("No JSON web service action with path " + urlPath);
    }
}

