/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.sync.internal.configuration.SyncServiceConfigurationValues;
import com.liferay.sync.model.SyncDLFileVersionDiff;
import com.liferay.sync.service.base.SyncDLFileVersionDiffLocalServiceBaseImpl;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.sync.model.SyncDLFileVersionDiff"}, service={AopService.class})
public class SyncDLFileVersionDiffLocalServiceImpl
extends SyncDLFileVersionDiffLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(SyncDLFileVersionDiffLocalServiceImpl.class);
    @Reference
    private PortletFileRepository _portletFileRepository;

    public SyncDLFileVersionDiff addSyncDLFileVersionDiff(long fileEntryId, long sourceFileVersionId, long targetFileVersionId, File file) throws PortalException {
        long syncDLFileVersionDiffId = this.counterLocalService.increment();
        SyncDLFileVersionDiff syncDLFileVersionDiff = this.syncDLFileVersionDiffPersistence.create(syncDLFileVersionDiffId);
        syncDLFileVersionDiff.setFileEntryId(fileEntryId);
        syncDLFileVersionDiff.setSourceFileVersionId(sourceFileVersionId);
        syncDLFileVersionDiff.setTargetFileVersionId(targetFileVersionId);
        FileEntry fileEntry = this.dlAppLocalService.getFileEntry(fileEntryId);
        Company company = this.companyLocalService.getCompanyById(fileEntry.getCompanyId());
        String dataFileName = this.getDataFileName(fileEntryId, sourceFileVersionId, targetFileVersionId);
        FileEntry dataFileEntry = this._portletFileRepository.addPortletFileEntry(company.getGroupId(), fileEntry.getUserId(), SyncDLFileVersionDiff.class.getName(), syncDLFileVersionDiff.getSyncDLFileVersionDiffId(), "com_liferay_document_library_web_portlet_DLPortlet", 0L, file, dataFileName, fileEntry.getMimeType(), false);
        syncDLFileVersionDiff.setDataFileEntryId(dataFileEntry.getFileEntryId());
        syncDLFileVersionDiff.setSize(file.length());
        Date expirationDate = new Date();
        expirationDate.setTime(expirationDate.getTime() + SyncServiceConfigurationValues.SYNC_FILE_DIFF_CACHE_EXPIRATION_TIME * 3600000L);
        syncDLFileVersionDiff.setExpirationDate(expirationDate);
        this.syncDLFileVersionDiffPersistence.update((BaseModel)syncDLFileVersionDiff);
        return syncDLFileVersionDiff;
    }

    public void deleteExpiredSyncDLFileVersionDiffs() throws PortalException {
        List syncDLFileVersionDiffs = this.syncDLFileVersionDiffPersistence.findByExpirationDate(new Date());
        for (SyncDLFileVersionDiff syncDLFileVersionDiff : syncDLFileVersionDiffs) {
            this.deleteSyncDLFileVersionDiff(syncDLFileVersionDiff);
        }
    }

    @Override
    public SyncDLFileVersionDiff deleteSyncDLFileVersionDiff(SyncDLFileVersionDiff syncDLFileVersionDiff) throws PortalException {
        block2: {
            try {
                this._portletFileRepository.deletePortletFileEntry(syncDLFileVersionDiff.getDataFileEntryId());
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to delete file entry " + syncDLFileVersionDiff.getDataFileEntryId()));
            }
        }
        return super.deleteSyncDLFileVersionDiff(syncDLFileVersionDiff);
    }

    public void deleteSyncDLFileVersionDiffs(long fileEntryId) throws PortalException {
        List syncDLFileVersionDiffs = this.syncDLFileVersionDiffPersistence.findByFileEntryId(fileEntryId);
        for (SyncDLFileVersionDiff syncDLFileVersionDiff : syncDLFileVersionDiffs) {
            this.deleteSyncDLFileVersionDiff(syncDLFileVersionDiff);
        }
    }

    public SyncDLFileVersionDiff fetchSyncDLFileVersionDiff(long fileEntryId, long sourceFileVersionId, long targetFileVersionId) {
        return this.syncDLFileVersionDiffPersistence.fetchByF_S_T(fileEntryId, sourceFileVersionId, targetFileVersionId);
    }

    public void refreshExpirationDate(long syncDLFileVersionDiffId) throws PortalException {
        SyncDLFileVersionDiff syncDLFileVersionDiff = this.syncDLFileVersionDiffPersistence.findByPrimaryKey(syncDLFileVersionDiffId);
        Date expirationDate = new Date();
        expirationDate.setTime(expirationDate.getTime() + SyncServiceConfigurationValues.SYNC_FILE_DIFF_CACHE_EXPIRATION_TIME * 3600000L);
        syncDLFileVersionDiff.setExpirationDate(expirationDate);
        this.updateSyncDLFileVersionDiff(syncDLFileVersionDiff);
    }

    protected String getDataFileName(long fileEntryId, long sourceFileVersionId, long targetFileVersionId) {
        StringBundler sb = new StringBundler(5);
        sb.append(fileEntryId);
        sb.append("_");
        sb.append(sourceFileVersionId);
        sb.append("_");
        sb.append(targetFileVersionId);
        return sb.toString();
    }
}

