/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.internal.util;

import com.liferay.document.library.kernel.exception.NoSuchFileVersionException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.petra.io.delta.ByteChannelReader;
import com.liferay.petra.io.delta.ByteChannelWriter;
import com.liferay.petra.io.delta.DeltaUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.SecureRandom;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.sync.SyncSiteUnavailableException;
import com.liferay.sync.constants.SyncPermissionsConstants;
import com.liferay.sync.internal.configuration.SyncServiceConfigurationValues;
import com.liferay.sync.internal.util.SyncDeviceThreadLocal;
import com.liferay.sync.model.SyncDLObject;
import com.liferay.sync.model.SyncDevice;
import com.liferay.sync.model.impl.SyncDLObjectImpl;
import com.liferay.sync.service.SyncDLObjectLocalService;
import com.liferay.sync.util.SyncHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletPreferences;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SyncHelper.class})
public class SyncHelperImpl
implements SyncHelper {
    private static final Log _log = LogFactoryUtil.getLog(SyncHelperImpl.class);
    private final Map<String, String> _checksums = new ConcurrentHashMap<String, String>();
    private DLFileVersionLocalService _dlFileVersionLocalService;
    private GroupLocalService _groupLocalService;
    private final Map<String, String> _lanTokenKeys = new ConcurrentHashMap<String, String>();
    private final Provider _provider = new BouncyCastleProvider();

    public void addChecksum(long modifiedTime, long typePK, String checksum) {
        String id = modifiedTime + "." + typePK;
        this._checksums.put(id, checksum);
    }

    public void addSyncDLObject(SyncDLObject syncDLObject, SyncDLObjectLocalService syncDLObjectLocalService) throws PortalException {
        String event = syncDLObject.getEvent();
        if (event.equals("delete") || event.equals("trash")) {
            syncDLObjectLocalService.addSyncDLObject(0L, syncDLObject.getUserId(), syncDLObject.getUserName(), syncDLObject.getModifiedTime(), 0L, 0L, syncDLObject.getTreePath(), "", "", "", "", "", "", "", 0L, 0L, "", event, "", null, 0L, "", syncDLObject.getType(), syncDLObject.getTypePK(), "");
        } else {
            syncDLObjectLocalService.addSyncDLObject(syncDLObject.getCompanyId(), syncDLObject.getUserId(), syncDLObject.getUserName(), syncDLObject.getModifiedTime(), syncDLObject.getRepositoryId(), syncDLObject.getParentFolderId(), syncDLObject.getTreePath(), syncDLObject.getName(), syncDLObject.getExtension(), syncDLObject.getMimeType(), syncDLObject.getDescription(), syncDLObject.getChangeLog(), syncDLObject.getExtraSettings(), syncDLObject.getVersion(), syncDLObject.getVersionId(), syncDLObject.getSize(), syncDLObject.getChecksum(), syncDLObject.getEvent(), syncDLObject.getLanTokenKey(), syncDLObject.getLockExpirationDate(), syncDLObject.getLockUserId(), syncDLObject.getLockUserName(), syncDLObject.getType(), syncDLObject.getTypePK(), syncDLObject.getTypeUuid());
        }
    }

    public String buildExceptionMessage(Throwable throwable) {
        String throwableMessage;
        StringBundler sb = new StringBundler(13);
        if (throwable instanceof InvocationTargetException) {
            throwable = throwable.getCause();
        }
        if (Validator.isNull((String)(throwableMessage = throwable.getMessage()))) {
            throwableMessage = throwable.toString();
        }
        sb.append("\"");
        sb.append(throwableMessage);
        sb.append("\"");
        sb.append(", ");
        sb.append("\"error\": ");
        JSONObject errorJSONObject = JSONUtil.put((String)"message", (Object)throwableMessage).put("type", ClassUtil.getClassName((Object)throwable));
        sb.append(errorJSONObject.toString());
        sb.append(", ");
        sb.append("\"throwable\": \"");
        sb.append(throwable.toString());
        sb.append("\"");
        if (throwable.getCause() == null) {
            return StringUtil.unquote((String)sb.toString());
        }
        sb.append(", ");
        sb.append("\"rootCause\": ");
        Throwable rootCauseThrowable = throwable;
        while (rootCauseThrowable.getCause() != null) {
            rootCauseThrowable = rootCauseThrowable.getCause();
        }
        throwableMessage = rootCauseThrowable.getMessage();
        if (Validator.isNull((String)throwableMessage)) {
            throwableMessage = rootCauseThrowable.toString();
        }
        JSONObject rootCauseJSONObject = JSONUtil.put((String)"message", (Object)throwableMessage).put("type", ClassUtil.getClassName((Object)rootCauseThrowable));
        sb.append((Object)rootCauseJSONObject);
        return StringUtil.unquote((String)sb.toString());
    }

    public void checkSyncEnabled(long groupId) throws PortalException {
        SyncDevice syncDevice = SyncDeviceThreadLocal.getSyncDevice();
        if (syncDevice != null) {
            syncDevice.checkStatus();
        }
        if (groupId == 0L) {
            return;
        }
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null || !this.isSyncEnabled(group)) {
            throw new SyncSiteUnavailableException();
        }
    }

    public void enableLanSync(long companyId) throws Exception {
        String lanServerUuid = PrefsPropsUtil.getString((long)companyId, (String)"sync.lan.server.uuid");
        if (Validator.isNotNull((String)lanServerUuid)) {
            return;
        }
        lanServerUuid = PortalUUIDUtil.generate();
        X500Name x500Name = new X500Name("CN=" + lanServerUuid);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        JcaX509v3CertificateBuilder x509v3CertificateBuilder = new JcaX509v3CertificateBuilder(x500Name, new BigInteger(64, (Random)new SecureRandom()), new Date(System.currentTimeMillis() - 31536000000L), new Date(System.currentTimeMillis() + 31536000000000L), x500Name, keyPair.getPublic());
        PrivateKey privateKey = keyPair.getPrivate();
        JcaContentSignerBuilder jcaContentSignerBuilder = new JcaContentSignerBuilder("SHA256WithRSAEncryption");
        JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
        jcaX509CertificateConverter.setProvider(this._provider);
        X509Certificate x509Certificate = jcaX509CertificateConverter.getCertificate(x509v3CertificateBuilder.build(jcaContentSignerBuilder.build(privateKey)));
        x509Certificate.verify(keyPair.getPublic());
        PortletPreferences portletPreferences = PrefsPropsUtil.getPreferences((long)companyId);
        portletPreferences.setValue("sync.lan.certificate", Base64.encode((byte[])x509Certificate.getEncoded()));
        portletPreferences.setValue("sync.lan.key", Base64.encode((byte[])privateKey.getEncoded()));
        portletPreferences.setValue("sync.lan.server.uuid", lanServerUuid);
        portletPreferences.store();
    }

    public String getChecksum(DLFileVersion dlFileVersion) {
        if (dlFileVersion.getSize() > (long)SyncServiceConfigurationValues.SYNC_FILE_CHECKSUM_THRESHOLD_SIZE) {
            return "";
        }
        try {
            return DigesterUtil.digestBase64((String)"SHA-1", (InputStream)dlFileVersion.getContentStream(false));
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getChecksum(File file) {
        if (file.length() > (long)SyncServiceConfigurationValues.SYNC_FILE_CHECKSUM_THRESHOLD_SIZE) {
            return "";
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            String string = DigesterUtil.digestBase64((String)"SHA-1", (InputStream)fileInputStream);
            return string;
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getChecksum(long modifiedTime, long typePK) {
        String id = modifiedTime + "." + typePK;
        return this._checksums.remove(id);
    }

    public File getFileDelta(File sourceFile, File targetFile) throws PortalException {
        Throwable throwable;
        Throwable throwable2;
        Throwable throwable3;
        Throwable throwable4;
        File deltaFile = null;
        File checksumsFile = FileUtil.createTempFile();
        try {
            throwable4 = null;
            try (FileInputStream sourceFileInputStream = new FileInputStream(sourceFile);){
                throwable3 = null;
                try (FileChannel sourceFileChannel = sourceFileInputStream.getChannel();){
                    throwable2 = null;
                    try (FileOutputStream checksumsOutputStream = new FileOutputStream(checksumsFile);){
                        throwable = null;
                        try (WritableByteChannel checksumsWritableByteChannel = Channels.newChannel(checksumsOutputStream);){
                            ByteChannelWriter checksumsByteChannelWriter = new ByteChannelWriter(checksumsWritableByteChannel);
                            DeltaUtil.checksums((FileChannel)sourceFileChannel, (ByteChannelWriter)checksumsByteChannelWriter);
                            checksumsByteChannelWriter.finish();
                        }
                        catch (Throwable checksumsByteChannelWriter) {
                            throwable = checksumsByteChannelWriter;
                            throw checksumsByteChannelWriter;
                        }
                    }
                    catch (Throwable checksumsWritableByteChannel) {
                        throwable2 = checksumsWritableByteChannel;
                        throw checksumsWritableByteChannel;
                    }
                }
                catch (Throwable checksumsOutputStream) {
                    throwable3 = checksumsOutputStream;
                    throw checksumsOutputStream;
                }
            }
            catch (Throwable sourceFileChannel) {
                throwable4 = sourceFileChannel;
                throw sourceFileChannel;
            }
        }
        catch (Exception e) {
            throw new PortalException((Throwable)e);
        }
        deltaFile = FileUtil.createTempFile();
        try {
            throwable4 = null;
            try (FileInputStream targetFileInputStream = new FileInputStream(targetFile);){
                throwable3 = null;
                try (FileChannel targetReadableByteChannel = targetFileInputStream.getChannel();){
                    throwable2 = null;
                    try (FileInputStream checksumsInputStream = new FileInputStream(checksumsFile);){
                        throwable = null;
                        try (ReadableByteChannel checksumsReadableByteChannel = Channels.newChannel(checksumsInputStream);
                             FileOutputStream deltaOutputStream = new FileOutputStream(deltaFile);
                             WritableByteChannel deltaOutputStreamWritableByteChannel = Channels.newChannel(deltaOutputStream);){
                            ByteChannelReader checksumsByteChannelReader = new ByteChannelReader(checksumsReadableByteChannel);
                            ByteChannelWriter deltaByteChannelWriter = new ByteChannelWriter(deltaOutputStreamWritableByteChannel);
                            DeltaUtil.delta((ReadableByteChannel)targetReadableByteChannel, (ByteChannelReader)checksumsByteChannelReader, (ByteChannelWriter)deltaByteChannelWriter);
                            deltaByteChannelWriter.finish();
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                }
                catch (Throwable throwable7) {
                    throwable3 = throwable7;
                    throw throwable7;
                }
            }
            catch (Throwable throwable8) {
                throwable4 = throwable8;
                throw throwable8;
            }
        }
        catch (Exception e) {
            throw new PortalException((Throwable)e);
        }
        finally {
            FileUtil.delete((File)checksumsFile);
        }
        return deltaFile;
    }

    public String getLanTokenKey(long modifiedTime, long typePK, boolean addToMap) {
        String id = modifiedTime + "." + typePK;
        String lanTokenKey = this._lanTokenKeys.remove(id);
        if (lanTokenKey != null) {
            return lanTokenKey;
        }
        lanTokenKey = PwdGenerator.getPassword();
        if (addToMap) {
            this._lanTokenKeys.put(id, lanTokenKey);
        }
        return lanTokenKey;
    }

    public boolean isSupportedFolder(DLFolder dlFolder) {
        return !dlFolder.isHidden() && !dlFolder.isMountPoint();
    }

    public boolean isSupportedFolder(Folder folder) {
        if (!(folder.getModel() instanceof DLFolder)) {
            return false;
        }
        DLFolder dlFolder = (DLFolder)folder.getModel();
        return this.isSupportedFolder(dlFolder);
    }

    public boolean isSyncEnabled(Group group) {
        if (group.isUser() && !PrefsPropsUtil.getBoolean((long)group.getCompanyId(), (String)"sync.allow.user.personal.sites", (boolean)SyncServiceConfigurationValues.SYNC_ALLOW_USER_PERSONAL_SITES)) {
            return false;
        }
        return GetterUtil.getBoolean((String)group.getTypeSettingsProperty("syncEnabled"), (!group.isCompany() ? 1 : 0) != 0);
    }

    public void patchFile(File originalFile, File deltaFile, File patchedFile) throws PortalException {
        try (FileInputStream originalFileInputStream = new FileInputStream(originalFile);
             FileChannel originalFileChannel = originalFileInputStream.getChannel();
             FileOutputStream patchedFileOutputStream = new FileOutputStream(patchedFile);
             WritableByteChannel patchedWritableByteChannel = Channels.newChannel(patchedFileOutputStream);
             FileInputStream deltaInputStream = new FileInputStream(deltaFile);
             ReadableByteChannel deltaReadableByteChannel = Channels.newChannel(deltaInputStream);){
            ByteChannelReader deltaByteChannelReader = new ByteChannelReader(deltaReadableByteChannel);
            DeltaUtil.patch((FileChannel)originalFileChannel, (WritableByteChannel)patchedWritableByteChannel, (ByteChannelReader)deltaByteChannelReader);
        }
        catch (Exception e) {
            throw new PortalException((Throwable)e);
        }
    }

    public void setFilePermissions(Group group, boolean folder, ServiceContext serviceContext) {
        int syncSiteMemberFilePermissions = GetterUtil.getInteger((String)group.getTypeSettingsProperty("syncSiteMemberFilePermissions"));
        if (syncSiteMemberFilePermissions == 0) {
            serviceContext.setDeriveDefaultPermissions(true);
            return;
        }
        String[] resourceActions = null;
        resourceActions = folder ? SyncPermissionsConstants.getFolderResourceActions((int)syncSiteMemberFilePermissions) : SyncPermissionsConstants.getFileResourceActions((int)syncSiteMemberFilePermissions);
        ModelPermissions modelPermissions = serviceContext.getModelPermissions();
        if (modelPermissions == null) {
            modelPermissions = new ModelPermissions();
        }
        modelPermissions.addRolePermissions("PLACEHOLDER_DEFAULT_GROUP_ROLE", resourceActions);
        serviceContext.setModelPermissions(modelPermissions);
    }

    public SyncDLObject toSyncDLObject(DLFileEntry dlFileEntry, String event, boolean calculateChecksum) throws PortalException {
        return this.toSyncDLObject(dlFileEntry, event, calculateChecksum, false);
    }

    public SyncDLObject toSyncDLObject(DLFileEntry dlFileEntry, String event, boolean calculateChecksum, boolean excludeWorkingCopy) throws PortalException {
        DLFileVersion dlFileVersion = null;
        Date lockExpirationDate = null;
        long lockUserId = 0L;
        String lockUserName = "";
        String type = null;
        Lock lock = dlFileEntry.getLock();
        if (lock == null || excludeWorkingCopy) {
            dlFileVersion = this._dlFileVersionLocalService.getFileVersion(dlFileEntry.getFileEntryId(), dlFileEntry.getVersion());
            type = "file";
        } else {
            try {
                dlFileVersion = this._dlFileVersionLocalService.getFileVersion(dlFileEntry.getFileEntryId(), "PWC");
                lockExpirationDate = lock.getExpirationDate();
                lockUserId = lock.getUserId();
                lockUserName = lock.getUserName();
                type = "privateWorkingCopy";
            }
            catch (NoSuchFileVersionException nsfve) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)nsfve, (Throwable)nsfve);
                }
                dlFileVersion = this._dlFileVersionLocalService.getFileVersion(dlFileEntry.getFileEntryId(), dlFileEntry.getVersion());
                type = "file";
            }
        }
        SyncDLObjectImpl syncDLObject = new SyncDLObjectImpl();
        syncDLObject.setCompanyId(dlFileVersion.getCompanyId());
        syncDLObject.setUserId(dlFileVersion.getStatusByUserId());
        syncDLObject.setUserName(dlFileVersion.getStatusByUserName());
        syncDLObject.setCreateDate(dlFileVersion.getCreateDate());
        syncDLObject.setModifiedDate(dlFileVersion.getModifiedDate());
        syncDLObject.setRepositoryId(dlFileVersion.getRepositoryId());
        syncDLObject.setParentFolderId(dlFileVersion.getFolderId());
        syncDLObject.setTreePath(dlFileVersion.getTreePath());
        syncDLObject.setName(dlFileVersion.getTitle());
        syncDLObject.setExtension(dlFileVersion.getExtension());
        syncDLObject.setMimeType(dlFileVersion.getMimeType());
        syncDLObject.setDescription(dlFileVersion.getDescription());
        syncDLObject.setChangeLog(dlFileVersion.getChangeLog());
        syncDLObject.setVersion(dlFileVersion.getVersion());
        syncDLObject.setVersionId(dlFileVersion.getFileVersionId());
        syncDLObject.setSize(dlFileVersion.getSize());
        if (calculateChecksum) {
            if (Validator.isNull((String)dlFileVersion.getChecksum())) {
                syncDLObject.setChecksum(this.getChecksum(dlFileVersion));
            } else {
                syncDLObject.setChecksum(dlFileVersion.getChecksum());
            }
        }
        syncDLObject.setEvent(event);
        syncDLObject.setLockExpirationDate(lockExpirationDate);
        syncDLObject.setLockUserId(lockUserId);
        syncDLObject.setLockUserName(lockUserName);
        syncDLObject.setType(type);
        syncDLObject.setTypePK(dlFileEntry.getFileEntryId());
        syncDLObject.setTypeUuid(dlFileEntry.getUuid());
        return syncDLObject;
    }

    public SyncDLObject toSyncDLObject(DLFolder dlFolder, long userId, String userName, String event) {
        SyncDLObjectImpl syncDLObject = new SyncDLObjectImpl();
        syncDLObject.setCompanyId(dlFolder.getCompanyId());
        syncDLObject.setUserId(userId);
        syncDLObject.setUserName(userName);
        syncDLObject.setCreateDate(dlFolder.getCreateDate());
        syncDLObject.setModifiedDate(dlFolder.getModifiedDate());
        syncDLObject.setRepositoryId(dlFolder.getRepositoryId());
        syncDLObject.setParentFolderId(dlFolder.getParentFolderId());
        syncDLObject.setTreePath(dlFolder.getTreePath());
        syncDLObject.setName(dlFolder.getName());
        syncDLObject.setDescription(dlFolder.getDescription());
        syncDLObject.setEvent(event);
        syncDLObject.setType("folder");
        syncDLObject.setTypePK(dlFolder.getFolderId());
        syncDLObject.setTypeUuid(dlFolder.getUuid());
        return syncDLObject;
    }

    public SyncDLObject toSyncDLObject(DLFolder dlFolder, String event) {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null) {
            return this.toSyncDLObject(dlFolder, 0L, "", event);
        }
        User user = permissionChecker.getUser();
        return this.toSyncDLObject(dlFolder, user.getUserId(), user.getFullName(), event);
    }

    public SyncDLObject toSyncDLObject(FileEntry fileEntry, String event) throws PortalException {
        return this.toSyncDLObject(fileEntry, event, false);
    }

    public SyncDLObject toSyncDLObject(FileEntry fileEntry, String event, boolean calculateChecksum) throws PortalException {
        if (fileEntry.getModel() instanceof DLFileEntry) {
            DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
            return this.toSyncDLObject(dlFileEntry, event, calculateChecksum);
        }
        throw new PortalException("FileEntry must be an instance of DLFileEntry");
    }

    public SyncDLObject toSyncDLObject(Folder folder, String event) throws PortalException {
        if (folder.getModel() instanceof DLFolder) {
            DLFolder dlFolder = (DLFolder)folder.getModel();
            return this.toSyncDLObject(dlFolder, event);
        }
        throw new PortalException("Folder must be an instance of DLFolder");
    }

    @Reference(unbind="-")
    protected void setDLFileVersionLocalService(DLFileVersionLocalService dlFileVersionLocalService) {
        this._dlFileVersionLocalService = dlFileVersionLocalService;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }
}

