/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.internal.servlet.filter;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.upload.UploadServletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.sync.SyncClientMinBuildException;
import com.liferay.sync.SyncDeviceHeaderException;
import com.liferay.sync.SyncServicesUnavailableException;
import com.liferay.sync.internal.util.SyncDeviceThreadLocal;
import com.liferay.sync.model.SyncDevice;
import com.liferay.sync.service.SyncDeviceLocalServiceUtil;
import com.liferay.sync.service.internal.configuration.SyncServiceConfigurationValues;
import com.liferay.sync.util.SyncHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"after-filter=Upload Servlet Request Filter", "servlet-context-name=", "servlet-filter-name=Sync JSON Filter", "url-pattern=/api/jsonws/*"}, service={Filter.class})
public class SyncJSONFilter
implements Filter {
    private static final int _ABSOLUTE_SYNC_CLIENT_MIN_BUILD_ANDROID = 26;
    private static final int _ABSOLUTE_SYNC_CLIENT_MIN_BUILD_DESKTOP = 3200;
    private static final int _ABSOLUTE_SYNC_CLIENT_MIN_BUILD_IOS = 7;
    @Reference
    private Portal _portal;
    @Reference
    private SyncHelper _syncHelper;

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        SyncDevice syncDevice = null;
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String uuid = httpServletRequest.getHeader("Sync-UUID");
        if (uuid != null) {
            syncDevice = SyncDeviceLocalServiceUtil.fetchSyncDeviceByUuidAndCompanyId((String)uuid, (long)this._portal.getCompanyId(httpServletRequest));
        }
        if (syncDevice == null) {
            syncDevice = SyncDeviceLocalServiceUtil.createSyncDevice((long)0L);
        }
        syncDevice.setHostname(servletRequest.getRemoteHost());
        SyncDeviceThreadLocal.setSyncDevice(syncDevice);
        if (uuid != null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String uri = (String)servletRequest.getAttribute("INVOKER_FILTER_URI");
        if (uri.equals("/api/jsonws/invoke")) {
            String contentType = httpServletRequest.getHeader("Content-Type");
            if (contentType == null || !contentType.startsWith("multipart/form-data")) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            if (!(httpServletRequest instanceof UploadServletRequest)) {
                servletRequest = this._portal.getUploadServletRequest(httpServletRequest);
            }
            if (!this.isSyncJSONRequest(servletRequest)) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
        } else if (!uri.startsWith("/api/jsonws/sync")) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (ParamUtil.get((HttpServletRequest)httpServletRequest, (String)"debug", (boolean)false)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        SyncServicesUnavailableException throwable = null;
        if (PrefsPropsUtil.getBoolean((long)this._portal.getCompanyId(httpServletRequest), (String)"sync.services.enabled", (boolean)SyncServiceConfigurationValues.SYNC_SERVICES_ENABLED)) {
            int absoluteSyncClientMinBuild = 0;
            int syncClientMinBuild = 0;
            String syncDeviceType = httpServletRequest.getHeader("Sync-Device");
            if (syncDeviceType == null) {
                throwable = new SyncDeviceHeaderException();
            } else if (syncDeviceType.startsWith("desktop")) {
                absoluteSyncClientMinBuild = 3200;
                syncClientMinBuild = PrefsPropsUtil.getInteger((long)this._portal.getCompanyId(httpServletRequest), (String)"sync.client.min.build.desktop", (int)SyncServiceConfigurationValues.SYNC_CLIENT_MIN_BUILD_DESKTOP);
            } else if (syncDeviceType.equals("mobile-android")) {
                absoluteSyncClientMinBuild = 26;
                syncClientMinBuild = PrefsPropsUtil.getInteger((long)this._portal.getCompanyId(httpServletRequest), (String)"sync.client.min.build.android", (int)SyncServiceConfigurationValues.SYNC_CLIENT_MIN_BUILD_ANDROID);
            } else if (syncDeviceType.equals("mobile-ios")) {
                absoluteSyncClientMinBuild = 7;
                syncClientMinBuild = PrefsPropsUtil.getInteger((long)this._portal.getCompanyId(httpServletRequest), (String)"sync.client.min.build.ios", (int)SyncServiceConfigurationValues.SYNC_CLIENT_MIN_BUILD_IOS);
            } else {
                throwable = new SyncDeviceHeaderException();
            }
            if (throwable == null) {
                int syncBuild;
                if (syncClientMinBuild < absoluteSyncClientMinBuild) {
                    syncClientMinBuild = absoluteSyncClientMinBuild;
                }
                if ((syncBuild = httpServletRequest.getIntHeader("Sync-Build")) >= syncClientMinBuild) {
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
                throwable = new SyncClientMinBuildException("Sync client does not meet minimum build " + syncClientMinBuild);
            }
        } else {
            throwable = new SyncServicesUnavailableException();
        }
        servletResponse.setCharacterEncoding("UTF-8");
        servletResponse.setContentType("application/json");
        ServletOutputStream outputStream = servletResponse.getOutputStream();
        String json = this._syncHelper.buildExceptionMessage((Throwable)throwable);
        json = "{\"exception\": \"" + json + "\"}";
        outputStream.write(json.getBytes("UTF-8"));
        outputStream.close();
    }

    public void init(FilterConfig filterConfig) {
    }

    protected boolean isSyncJSONRequest(ServletRequest servletRequest) {
        try {
            String cmd = servletRequest.getParameter("cmd");
            if (cmd == null) {
                cmd = StringUtil.read((InputStream)servletRequest.getInputStream());
            }
            Object cmdObject = JSONFactoryUtil.looseDeserialize((String)cmd);
            ArrayList<Object> jsonItems = null;
            if (cmdObject instanceof List) {
                jsonItems = (ArrayList<Object>)cmdObject;
            } else if (cmdObject instanceof Map) {
                jsonItems = new ArrayList<Object>(1);
                jsonItems.add(cmdObject);
            }
            for (Object e : jsonItems) {
                Map map = (Map)e;
                Set keySet = map.keySet();
                Iterator iterator = keySet.iterator();
                String key = (String)iterator.next();
                if (!key.startsWith("/sync-web.") && !key.startsWith("/sync-web/") && !key.startsWith("/sync.") && !key.startsWith("/sync/")) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

