/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.internal.messaging;

import com.liferay.document.library.sync.service.DLSyncEventLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.sync.model.SyncDLObject;
import com.liferay.sync.service.SyncDLFileVersionDiffLocalService;
import com.liferay.sync.service.SyncDLObjectLocalService;
import com.liferay.sync.service.internal.configuration.SyncServiceConfigurationValues;
import java.util.Date;
import java.util.HashMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SyncMaintenanceMessageListener.class})
public class SyncMaintenanceMessageListener
extends BaseMessageListener {
    public static final String DESTINATION_NAME = "liferay/sync_maintenance_processor";
    private static final Log _log = LogFactoryUtil.getLog(SyncMaintenanceMessageListener.class);
    private DLSyncEventLocalService _dlSyncEventLocalService;
    private SchedulerEngineHelper _schedulerEngineHelper;
    private SyncDLFileVersionDiffLocalService _syncDLFileVersionDiffLocalService;
    private SyncDLObjectLocalService _syncDLObjectLocalService;
    @Reference
    private TriggerFactory _triggerFactory;

    @Activate
    protected void activate() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String className = clazz.getName();
        Date startDate = new Date(System.currentTimeMillis() + 3600000L);
        Trigger trigger = this._triggerFactory.createTrigger(className, className, startDate, null, 1, TimeUnit.HOUR);
        SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl(className, trigger);
        this._schedulerEngineHelper.register((MessageListener)this, (SchedulerEntry)schedulerEntry, DESTINATION_NAME);
    }

    @Deactivate
    protected void deactivate() {
        this._schedulerEngineHelper.unregister((MessageListener)this);
    }

    protected void doReceive(Message message) throws Exception {
        this._syncDLFileVersionDiffLocalService.deleteExpiredSyncDLFileVersionDiffs();
        if (SyncServiceConfigurationValues.SYNC_FILE_DIFF_CACHE_ENABLED) {
            try {
                this._syncDLFileVersionDiffLocalService.deleteExpiredSyncDLFileVersionDiffs();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        try {
            ActionableDynamicQuery actionableDynamicQuery = this._dlSyncEventLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
                Property modifiedTimeProperty = PropertyFactoryUtil.forName((String)"modifiedTime");
                dynamicQuery.add(modifiedTimeProperty.le((Object)this._syncDLObjectLocalService.getLatestModifiedTime()));
            });
            actionableDynamicQuery.setPerformActionMethod(dlSyncEvent -> {
                SyncDLObject syncDLObject = this._syncDLObjectLocalService.fetchSyncDLObject(dlSyncEvent.getType(), dlSyncEvent.getTypePK());
                if (syncDLObject == null || dlSyncEvent.getModifiedTime() > syncDLObject.getModifiedTime()) {
                    TransactionCommitCallbackUtil.registerCallback(() -> {
                        Message dlSyncEventMessage = new Message();
                        HashMap<String, Object> values = new HashMap<String, Object>();
                        values.put("event", dlSyncEvent.getEvent());
                        values.put("modifiedTime", this._syncDLObjectLocalService.getLatestModifiedTime() + 1L);
                        values.put("type", dlSyncEvent.getType());
                        values.put("typePK", dlSyncEvent.getTypePK());
                        dlSyncEventMessage.setValues(values);
                        MessageBusUtil.sendMessage((String)"liferay/document_library_sync_event_processor", (Message)dlSyncEventMessage);
                        return null;
                    });
                } else {
                    this._dlSyncEventLocalService.deleteDLSyncEvent(dlSyncEvent);
                }
            });
            actionableDynamicQuery.performActions();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    @Reference(unbind="-")
    protected void setDLSyncEventLocalService(DLSyncEventLocalService dlSyncEventLocalService) {
        this._dlSyncEventLocalService = dlSyncEventLocalService;
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    @Reference(unbind="-")
    protected void setSchedulerEngineHelper(SchedulerEngineHelper schedulerEngineHelper) {
        this._schedulerEngineHelper = schedulerEngineHelper;
    }

    @Reference(unbind="-")
    protected void setSyncDLFileVersionDiffLocalService(SyncDLFileVersionDiffLocalService syncDLFileVersionDiffLocalService) {
        this._syncDLFileVersionDiffLocalService = syncDLFileVersionDiffLocalService;
    }

    @Reference(unbind="-")
    protected void setSyncDLObjectLocalService(SyncDLObjectLocalService syncDLObjectLocalService) {
        this._syncDLObjectLocalService = syncDLObjectLocalService;
    }
}

