/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.sync.internal.util.SyncDeviceThreadLocal;
import com.liferay.sync.model.SyncDevice;
import com.liferay.sync.service.base.SyncDeviceServiceBaseImpl;

public class SyncDeviceServiceImpl
extends SyncDeviceServiceBaseImpl {
    public SyncDevice registerSyncDevice(String type, long buildNumber, int featureSet, String uuid) throws PortalException {
        User user = this.getUser();
        SyncDevice syncDevice = this.syncDeviceLocalService.fetchSyncDeviceByUuidAndCompanyId(uuid, user.getCompanyId());
        if (syncDevice == null) {
            syncDevice = SyncDeviceThreadLocal.getSyncDevice();
            return this.syncDeviceLocalService.addSyncDevice(user.getUserId(), type, buildNumber, syncDevice.getHostname(), featureSet);
        }
        if (syncDevice.getUserId() != user.getUserId()) {
            throw new PrincipalException();
        }
        return this.syncDeviceLocalService.updateSyncDevice(syncDevice.getSyncDeviceId(), type, buildNumber, featureSet, syncDevice.getHostname(), syncDevice.getStatus());
    }

    public void unregisterSyncDevice(String uuid) throws PortalException {
        User user = this.getUser();
        SyncDevice syncDevice = this.syncDeviceLocalService.fetchSyncDeviceByUuidAndCompanyId(uuid, user.getCompanyId());
        if (syncDevice == null || syncDevice.getUserId() != user.getUserId() || syncDevice.getStatus() == 3) {
            return;
        }
        this.syncDeviceLocalService.deleteSyncDevice(syncDevice);
    }
}

