/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.internal.model.listener;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.sync.internal.model.listener.UserModelListener;
import com.liferay.sync.model.SyncDLObject;
import com.liferay.sync.service.SyncDLObjectLocalService;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Reference;

public abstract class SyncBaseModelListener<T extends BaseModel<T>>
extends BaseModelListener<T> {
    @Reference
    protected PortalExecutorManager portalExecutorManager;
    @Reference
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    @Reference
    protected SyncDLObjectLocalService syncDLObjectLocalService;

    protected SyncDLObject getSyncDLObject(ResourcePermission resourcePermission) {
        String modelName = resourcePermission.getName();
        if (modelName.equals(DLFileEntry.class.getName())) {
            return this.syncDLObjectLocalService.fetchSyncDLObject("file", GetterUtil.getLong((String)resourcePermission.getPrimKey()));
        }
        if (modelName.equals(DLFolder.class.getName())) {
            return this.syncDLObjectLocalService.fetchSyncDLObject("folder", GetterUtil.getLong((String)resourcePermission.getPrimKey()));
        }
        return null;
    }

    protected void onAddRoleAssociation(Object roleId) throws ModelListenerException {
        ActionableDynamicQuery actionableDynamicQuery = this._getActionableDynamicQuery(roleId);
        actionableDynamicQuery.setPerformActionMethod(resourcePermission -> {
            SyncDLObject syncDLObject = this.getSyncDLObject((ResourcePermission)resourcePermission);
            if (syncDLObject == null) {
                return;
            }
            this.updateSyncDLObject(syncDLObject);
        });
        TransactionCommitCallbackUtil.registerCallback(() -> {
            NoticeableExecutorService noticeableExecutorService = this.portalExecutorManager.getPortalExecutor(UserModelListener.class.getName());
            noticeableExecutorService.submit(() -> {
                try {
                    actionableDynamicQuery.performActions();
                }
                catch (Exception e) {
                    throw new ModelListenerException((Throwable)e);
                }
                return null;
            });
            return null;
        });
    }

    protected void onRemoveRoleAssociation(Object roleId) {
        ActionableDynamicQuery actionableDynamicQuery = this._getActionableDynamicQuery(roleId);
        actionableDynamicQuery.setPerformActionMethod(resourcePermission -> {
            SyncDLObject syncDLObject = this.getSyncDLObject((ResourcePermission)resourcePermission);
            if (syncDLObject == null) {
                return;
            }
            Date date = new Date();
            syncDLObject.setModifiedTime(date.getTime());
            syncDLObject.setLastPermissionChangeDate(date);
            this.syncDLObjectLocalService.updateSyncDLObject(syncDLObject);
        });
        TransactionCommitCallbackUtil.registerCallback(() -> {
            NoticeableExecutorService noticeableExecutorService = this.portalExecutorManager.getPortalExecutor(UserModelListener.class.getName());
            noticeableExecutorService.submit(() -> {
                try {
                    actionableDynamicQuery.performActions();
                }
                catch (Exception e) {
                    throw new ModelListenerException((Throwable)e);
                }
                return null;
            });
            return null;
        });
    }

    protected void updateSyncDLObject(SyncDLObject syncDLObject) {
        syncDLObject.setModifiedTime(System.currentTimeMillis());
        this.syncDLObjectLocalService.updateSyncDLObject(syncDLObject);
        String type = syncDLObject.getType();
        if (!type.equals("folder")) {
            return;
        }
        List childSyncDLObjects = this.syncDLObjectLocalService.getSyncDLObjects(syncDLObject.getRepositoryId(), syncDLObject.getTypePK());
        for (SyncDLObject childSyncDLObject : childSyncDLObjects) {
            this.updateSyncDLObject(childSyncDLObject);
        }
    }

    private ActionableDynamicQuery _getActionableDynamicQuery(Object roleId) {
        ActionableDynamicQuery actionableDynamicQuery = this.resourcePermissionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
            Property nameProperty = PropertyFactoryUtil.forName((String)"name");
            disjunction.add(nameProperty.eq((Object)DLFileEntry.class.getName()));
            disjunction.add(nameProperty.eq((Object)DLFolder.class.getName()));
            dynamicQuery.add((Criterion)disjunction);
            Property roleIdProperty = PropertyFactoryUtil.forName((String)"roleId");
            dynamicQuery.add(roleIdProperty.eq(roleId));
            Property viewActionIdProperty = PropertyFactoryUtil.forName((String)"viewActionId");
            dynamicQuery.add(viewActionIdProperty.eq((Object)true));
        });
        return actionableDynamicQuery;
    }
}

