/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.internal.upgrade.v1_0_2;

import com.liferay.document.library.kernel.service.DLSyncEventLocalService;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.sync.service.configuration.SyncServiceConfigurationValues;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;

public class UpgradeSyncDLObject
extends UpgradeProcess {
    private final DLSyncEventLocalService _dlSyncEventLocalService;
    private final GroupLocalService _groupLocalService;

    public UpgradeSyncDLObject(DLSyncEventLocalService dlSyncEventLocalService, GroupLocalService groupLocalService) {
        this._dlSyncEventLocalService = dlSyncEventLocalService;
        this._groupLocalService = groupLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            ActionableDynamicQuery actionableDynamicQuery = this._groupLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

                public void addCriteria(DynamicQuery dynamicQuery) {
                    Property classNameId = PropertyFactoryUtil.forName((String)"classNameId");
                    Property siteProperty = PropertyFactoryUtil.forName((String)"site");
                    dynamicQuery.add(RestrictionsFactoryUtil.or((Criterion)classNameId.eq((Object)PortalUtil.getClassNameId(User.class)), (Criterion)siteProperty.eq((Object)true)));
                }
            });
            actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Group>(){

                public void performAction(Group group) throws PortalException {
                    if (group.isStaged()) {
                        return;
                    }
                    try {
                        UpgradeSyncDLObject.this.verifyDLFileEntriesAndFolders(group.getGroupId());
                        UpgradeSyncDLObject.this.verifyLocks(group.getGroupId());
                        UpgradeSyncDLObject.this.verifyMacPackages(group.getGroupId());
                    }
                    catch (Exception e) {
                        throw new PortalException((Throwable)e);
                    }
                }
            });
            actionableDynamicQuery.performActions();
            this._dlSyncEventLocalService.deleteDLSyncEvents();
        }
    }

    protected void verifyDLFileEntriesAndFolders(long groupId) throws Exception {
        StringBundler sb1 = new StringBundler(50);
        sb1.append("select DLFolder.companyId, DLFolder.userId, ");
        sb1.append("DLFolder.userName, DLFolder.createDate, ");
        sb1.append("DLFolder.modifiedDate, DLFolder.repositoryId, ");
        sb1.append("DLFolder.parentFolderId as parentFolderId, ");
        sb1.append("DLFolder.treePath, DLFolder.name, '' as extension, '' as ");
        sb1.append("mimeType, DLFolder.description, '' as changeLog, '' as ");
        sb1.append("version, 0 as versionId, 0 as size_, '");
        sb1.append("folder");
        sb1.append("' as type, DLFolder.folderId as typePK, DLFolder.uuid_ ");
        sb1.append("as typeUuid, DLFolder.status from DLFolder where ");
        sb1.append("DLFolder.repositoryId = ");
        sb1.append(groupId);
        sb1.append(" union all select DLFileVersion.companyId, ");
        sb1.append("DLFileVersion.userId, DLFileVersion.userName, ");
        sb1.append("DLFileVersion.createDate, DLFileVersion.modifiedDate, ");
        sb1.append("DLFileVersion.repositoryId, DLFileVersion.folderId as ");
        sb1.append("parentFolderId, DLFileVersion.treePath, ");
        sb1.append("DLFileVersion.title as name, DLFileVersion.extension, ");
        sb1.append("DLFileVersion.mimeType, DLFileVersion.description, ");
        sb1.append("DLFileVersion.changeLog, DLFileVersion.version, ");
        sb1.append("DLFileVersion.fileVersionId as versionId, ");
        sb1.append("DLFileVersion.size_ as size_, '");
        sb1.append("file");
        sb1.append("' as type, DLFileVersion.fileEntryId as typePK, ");
        sb1.append("DLFileEntry.uuid_ as typeUuid, DLFileVersion.status from ");
        sb1.append("DLFileEntry, DLFileVersion where ");
        sb1.append("DLFileEntry.repositoryId = ");
        sb1.append(groupId);
        sb1.append(" and DLFileEntry.fileEntryId = DLFileVersion.fileEntryId ");
        sb1.append("and DLFileEntry.version = DLFileVersion.version union ");
        sb1.append("all select DLFileVersion.companyId, ");
        sb1.append("DLFileVersion.userId, DLFileVersion.userName, ");
        sb1.append("DLFileVersion.createDate, DLFileVersion.modifiedDate, ");
        sb1.append("DLFileVersion.repositoryId, DLFileVersion.folderId as ");
        sb1.append("parentFolderId, DLFileVersion.treePath, ");
        sb1.append("DLFileVersion.title as name, DLFileVersion.extension, ");
        sb1.append("DLFileVersion.mimeType, DLFileVersion.description, ");
        sb1.append("DLFileVersion.changeLog, DLFileVersion.version, ");
        sb1.append("DLFileVersion.fileVersionId as versionId, ");
        sb1.append("DLFileVersion.size_ as size_, '");
        sb1.append("privateWorkingCopy");
        sb1.append("' as type, DLFileVersion.fileEntryId as typePK, ");
        sb1.append("DLFileEntry.uuid_ as typeUuid, DLFileVersion.status from ");
        sb1.append("DLFileEntry, DLFileVersion where ");
        sb1.append("DLFileEntry.repositoryId = ");
        sb1.append(groupId);
        sb1.append(" and DLFileEntry.fileEntryId = DLFileVersion.fileEntryId ");
        sb1.append("and DLFileVersion.version = '");
        sb1.append("PWC");
        sb1.append("'");
        StringBundler sb2 = new StringBundler(6);
        sb2.append("insert into SyncDLObject (syncDLObjectId, companyId, ");
        sb2.append("userId, userName, createTime, modifiedTime, ");
        sb2.append("repositoryId, parentFolderId, treePath, name, extension, ");
        sb2.append("mimeType, description, changeLog, version, versionId, ");
        sb2.append("size_, event, type_, typePK, typeUuid) values (?, ?, ?, ");
        sb2.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb1.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb2.toString());
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                Timestamp createDate = rs.getTimestamp("createDate");
                Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                int status = rs.getInt("status");
                String event = "";
                event = status == 8 ? "trash" : "add";
                ps2.setLong(1, UpgradeSyncDLObject._increment());
                ps2.setLong(2, rs.getLong("companyId"));
                ps2.setLong(3, rs.getLong("userId"));
                ps2.setString(4, rs.getString("userName"));
                ps2.setLong(5, createDate.getTime());
                ps2.setLong(6, modifiedDate.getTime());
                ps2.setLong(7, groupId);
                ps2.setLong(8, rs.getLong("parentFolderId"));
                ps2.setString(9, rs.getString("treePath"));
                ps2.setString(10, rs.getString("name"));
                ps2.setString(11, rs.getString("extension"));
                ps2.setString(12, rs.getString("mimeType"));
                ps2.setString(13, rs.getString("description"));
                ps2.setString(14, rs.getString("changeLog"));
                ps2.setString(15, rs.getString("version"));
                ps2.setLong(16, rs.getLong("versionId"));
                ps2.setLong(17, rs.getLong("size_"));
                ps2.setString(18, event);
                ps2.setString(19, rs.getString("type"));
                ps2.setLong(20, rs.getLong("typePK"));
                ps2.setString(21, rs.getString("typeUuid"));
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected void verifyLocks(long groupId) throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("select Lock_.expirationDate, Lock_.userId, ");
        sb.append("Lock_.userName, DLFileVersion.fileEntryId from ");
        sb.append("DLFileVersion, Lock_ where DLFileVersion.version = '");
        sb.append("PWC");
        sb.append("' and CAST_TEXT(DLFileVersion.fileEntryId) = Lock_.key_");
        String sql = SQLTransformer.transform((String)sb.toString());
        try (PreparedStatement ps1 = this.connection.prepareStatement(sql);
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"update SyncDLObject set lockExpirationDate = ?, ", "lockUserId = ?, lockUserName = ? where typePK = ? ", "and repositoryId = ", String.valueOf(groupId)}));
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                ps2.setTimestamp(1, rs.getTimestamp("expirationDate"));
                ps2.setLong(2, rs.getLong("userId"));
                ps2.setString(3, rs.getString("userName"));
                ps2.setLong(4, rs.getLong("fileEntryId"));
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected void verifyMacPackages(long groupId) throws Exception {
        String[] fileNames = SyncServiceConfigurationValues.SYNC_MAC_PACKAGE_METADATA_FILE_NAMES;
        StringBundler sb = new StringBundler(fileNames.length * 4 + 5);
        sb.append("select DLFolder.folderId, DLFolder.name from DLFolder, ");
        sb.append("DLFileEntry where DLFolder.repositoryId = ");
        sb.append(groupId);
        sb.append(" and DLFileEntry.folderId = DLFolder.folderId and ");
        sb.append("DLFileEntry.title in (");
        for (int i = 0; i < fileNames.length; ++i) {
            sb.append("'");
            sb.append(fileNames[i]);
            sb.append("'");
            if (i == fileNames.length - 1) continue;
            sb.append(',');
        }
        sb.append(")");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update SyncDLObject set extraSettings = ? where typePK = ?");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                long folderId = rs.getLong("folderId");
                String name = rs.getString("name");
                String extension = FileUtil.getExtension((String)name);
                if (!ArrayUtil.contains((Object[])SyncServiceConfigurationValues.SYNC_MAC_PACKAGE_FOLDER_EXTENSIONS, (Object)extension)) continue;
                JSONObject extraSettingsJSONObject = JSONFactoryUtil.createJSONObject();
                extraSettingsJSONObject.put("macPackage", true);
                ps2.setString(1, extraSettingsJSONObject.toString());
                ps2.setLong(2, folderId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    private static long _increment() {
        DB db = DBManagerUtil.getDB();
        return db.increment();
    }
}

