/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.internal.model.listener;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.sync.model.SyncDLObject;
import com.liferay.sync.service.SyncDLObjectLocalService;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Reference;

public abstract class SyncBaseModelListener<T extends BaseModel<T>>
extends BaseModelListener<T> {
    @Reference
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    @Reference
    protected SyncDLObjectLocalService syncDLObjectLocalService;

    protected SyncDLObject getSyncDLObject(ResourcePermission resourcePermission) {
        String modelName = resourcePermission.getName();
        if (modelName.equals(DLFileEntry.class.getName())) {
            return this.syncDLObjectLocalService.fetchSyncDLObject("file", GetterUtil.getLong((String)resourcePermission.getPrimKey()));
        }
        if (modelName.equals(DLFolder.class.getName())) {
            return this.syncDLObjectLocalService.fetchSyncDLObject("folder", GetterUtil.getLong((String)resourcePermission.getPrimKey()));
        }
        return null;
    }

    protected void onAddRoleAssociation(Object roleId) throws ModelListenerException {
        ActionableDynamicQuery actionableDynamicQuery = this._getActionableDynamicQuery(roleId);
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<ResourcePermission>(){

            public void performAction(ResourcePermission resourcePermission) {
                SyncDLObject syncDLObject = SyncBaseModelListener.this.getSyncDLObject(resourcePermission);
                if (syncDLObject == null) {
                    return;
                }
                SyncBaseModelListener.this.updateSyncDLObject(syncDLObject);
            }
        });
        try {
            actionableDynamicQuery.performActions();
        }
        catch (Exception e) {
            throw new ModelListenerException((Throwable)e);
        }
    }

    protected void onRemoveRoleAssociation(Object roleId) {
        ActionableDynamicQuery actionableDynamicQuery = this._getActionableDynamicQuery(roleId);
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<ResourcePermission>(){

            public void performAction(ResourcePermission resourcePermission) {
                SyncDLObject syncDLObject = SyncBaseModelListener.this.getSyncDLObject(resourcePermission);
                if (syncDLObject == null) {
                    return;
                }
                Date date = new Date();
                syncDLObject.setModifiedTime(date.getTime());
                syncDLObject.setLastPermissionChangeDate(date);
                SyncBaseModelListener.this.syncDLObjectLocalService.updateSyncDLObject(syncDLObject);
            }
        });
        try {
            actionableDynamicQuery.performActions();
        }
        catch (Exception e) {
            throw new ModelListenerException((Throwable)e);
        }
    }

    protected void updateSyncDLObject(SyncDLObject syncDLObject) {
        syncDLObject.setModifiedTime(System.currentTimeMillis());
        this.syncDLObjectLocalService.updateSyncDLObject(syncDLObject);
        String type = syncDLObject.getType();
        if (!type.equals("folder")) {
            return;
        }
        List childSyncDLObjects = this.syncDLObjectLocalService.getSyncDLObjects(syncDLObject.getRepositoryId(), syncDLObject.getTypePK());
        for (SyncDLObject childSyncDLObject : childSyncDLObjects) {
            this.updateSyncDLObject(childSyncDLObject);
        }
    }

    private ActionableDynamicQuery _getActionableDynamicQuery(final Object roleId) {
        ActionableDynamicQuery actionableDynamicQuery = this.resourcePermissionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
                Property nameProperty = PropertyFactoryUtil.forName((String)"name");
                disjunction.add(nameProperty.eq((Object)DLFileEntry.class.getName()));
                disjunction.add(nameProperty.eq((Object)DLFolder.class.getName()));
                dynamicQuery.add((Criterion)disjunction);
                Property roleIdProperty = PropertyFactoryUtil.forName((String)"roleId");
                dynamicQuery.add(roleIdProperty.eq(roleId));
                Property viewActionIdProperty = PropertyFactoryUtil.forName((String)"viewActionId");
                dynamicQuery.add(viewActionIdProperty.eq((Object)true));
            }
        });
        return actionableDynamicQuery;
    }
}

