/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.internal.configurator;

import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.sync.service.configuration.SyncServiceConfigurationValues;
import com.liferay.sync.util.SyncUtil;
import com.liferay.sync.util.VerifyUtil;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PortalInstanceLifecycleListener.class})
public class SyncConfigurator
extends BasePortalInstanceLifecycleListener {
    private static final Log _log = LogFactoryUtil.getLog(SyncConfigurator.class);
    private volatile BundleContext _bundleContext;
    @Reference
    private DestinationFactory _destinationFactory;
    private ServiceRegistration<Destination> _dlSyncEventProcessorServiceRegistration;
    private ServiceRegistration<Destination> _syncMaintenanceProcessorServiceRegistration;
    @Reference
    private SyncUtil _syncUtil;
    @Reference
    private VerifyUtil _verifyUtil;

    public void portalInstanceRegistered(Company company) throws Exception {
        boolean lanEnabled = PrefsPropsUtil.getBoolean((long)company.getCompanyId(), (String)"sync.lan.enabled", (boolean)SyncServiceConfigurationValues.SYNC_LAN_ENABLED);
        if (lanEnabled) {
            try {
                SyncUtil.enableLanSync(company.getCompanyId());
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        try {
            if (SyncServiceConfigurationValues.SYNC_VERIFY) {
                this._verifyUtil.doVerify();
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        this._dlSyncEventProcessorServiceRegistration = this.registerMessageListener("liferay/document_library_sync_event_processor");
        this._syncMaintenanceProcessorServiceRegistration = this.registerMessageListener("liferay/sync_maintenance_processor");
    }

    @Deactivate
    protected void deactivate() {
        Destination destination;
        if (this._dlSyncEventProcessorServiceRegistration != null) {
            destination = (Destination)this._bundleContext.getService(this._dlSyncEventProcessorServiceRegistration.getReference());
            this._dlSyncEventProcessorServiceRegistration.unregister();
            destination.destroy();
        }
        if (this._syncMaintenanceProcessorServiceRegistration != null) {
            destination = (Destination)this._bundleContext.getService(this._syncMaintenanceProcessorServiceRegistration.getReference());
            this._syncMaintenanceProcessorServiceRegistration.unregister();
            destination.destroy();
        }
        this._bundleContext = null;
    }

    protected ServiceRegistration<Destination> registerMessageListener(String destinationName) {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("serial", destinationName);
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        HashMapDictionary destinationProperties = new HashMapDictionary();
        destinationProperties.put("destination.name", destination.getName());
        return this._bundleContext.registerService(Destination.class, (Object)destination, (Dictionary)destinationProperties);
    }
}

