/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.sync.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.sync.constants.SyncDeviceConstants;
import com.liferay.sync.model.SyncDevice;
import com.liferay.sync.service.base.SyncDeviceServiceBaseImpl;
import com.liferay.sync.util.SyncDeviceThreadLocal;

/**
 * @author Shinn Lok
 */
public class SyncDeviceServiceImpl extends SyncDeviceServiceBaseImpl {

	@Override
	public SyncDevice registerSyncDevice(
			String type, long buildNumber, int featureSet, String uuid)
		throws PortalException {

		User user = getUser();

		SyncDevice syncDevice =
			syncDeviceLocalService.fetchSyncDeviceByUuidAndCompanyId(
				uuid, user.getCompanyId());

		if (syncDevice == null) {
			syncDevice = SyncDeviceThreadLocal.getSyncDevice();

			return syncDeviceLocalService.addSyncDevice(
				user.getUserId(), type, buildNumber, syncDevice.getHostname(),
				featureSet);
		}

		if (syncDevice.getUserId() != user.getUserId()) {
			throw new PrincipalException();
		}

		return syncDeviceLocalService.updateSyncDevice(
			syncDevice.getSyncDeviceId(), type, buildNumber, featureSet,
			syncDevice.getHostname(), syncDevice.getStatus());
	}

	@Override
	public void unregisterSyncDevice(String uuid) throws PortalException {
		User user = getUser();

		SyncDevice syncDevice =
			syncDeviceLocalService.fetchSyncDeviceByUuidAndCompanyId(
				uuid, user.getCompanyId());

		if ((syncDevice == null) ||
			(syncDevice.getUserId() != user.getUserId()) ||
			(syncDevice.getStatus() == SyncDeviceConstants.STATUS_WIPED)) {

			return;
		}

		syncDeviceLocalService.deleteSyncDevice(syncDevice);
	}

}