/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.sync.service.configuration;

import com.liferay.portal.kernel.util.GetterUtil;

/**
 * @author Dennis Ju
 */
public class SyncServiceConfigurationValues {

	public static final boolean SYNC_ALLOW_USER_PERSONAL_SITES =
		GetterUtil.getBoolean(
			SyncServiceConfigurationUtil.get(
				SyncServiceConfigurationKeys.SYNC_ALLOW_USER_PERSONAL_SITES));

	public static final int SYNC_CLIENT_AUTHENTICATION_RETRY_INTERVAL =
		GetterUtil.getInteger(
			SyncServiceConfigurationUtil.get(
				SyncServiceConfigurationKeys.
					SYNC_CLIENT_AUTHENTICATION_RETRY_INTERVAL));

	public static final int SYNC_CLIENT_BATCH_FILE_MAX_SIZE =
		GetterUtil.getInteger(
			SyncServiceConfigurationUtil.get(
				SyncServiceConfigurationKeys.SYNC_CLIENT_BATCH_FILE_MAX_SIZE));

	public static final boolean SYNC_CLIENT_FORCE_SECURITY_MODE =
		GetterUtil.getBoolean(
			SyncServiceConfigurationUtil.get(
				SyncServiceConfigurationKeys.SYNC_CLIENT_FORCE_SECURITY_MODE));

	public static final int SYNC_CLIENT_MAX_CONNECTIONS = GetterUtil.getInteger(
		SyncServiceConfigurationUtil.get(
			SyncServiceConfigurationKeys.SYNC_CLIENT_MAX_CONNECTIONS));

	public static final int SYNC_CLIENT_MAX_DOWNLOAD_RATE =
		GetterUtil.getInteger(
			SyncServiceConfigurationUtil.get(
				SyncServiceConfigurationKeys.SYNC_CLIENT_MAX_DOWNLOAD_RATE));

	public static final int SYNC_CLIENT_MAX_UPLOAD_RATE = GetterUtil.getInteger(
		SyncServiceConfigurationUtil.get(
			SyncServiceConfigurationKeys.SYNC_CLIENT_MAX_UPLOAD_RATE));

	public static final int SYNC_CLIENT_MIN_BUILD_ANDROID =
		GetterUtil.getInteger(
			SyncServiceConfigurationUtil.get(
				SyncServiceConfigurationKeys.SYNC_CLIENT_MIN_BUILD_ANDROID));

	public static final int SYNC_CLIENT_MIN_BUILD_DESKTOP =
		GetterUtil.getInteger(
			SyncServiceConfigurationUtil.get(
				SyncServiceConfigurationKeys.SYNC_CLIENT_MIN_BUILD_DESKTOP));

	public static final int SYNC_CLIENT_MIN_BUILD_IOS = GetterUtil.getInteger(
		SyncServiceConfigurationUtil.get(
			SyncServiceConfigurationKeys.SYNC_CLIENT_MIN_BUILD_IOS));

	public static final int SYNC_CLIENT_POLL_INTERVAL = GetterUtil.getInteger(
		SyncServiceConfigurationUtil.get(
			SyncServiceConfigurationKeys.SYNC_CLIENT_POLL_INTERVAL));

	public static final int SYNC_FILE_CHECKSUM_THRESHOLD_SIZE =
		GetterUtil.getInteger(
			SyncServiceConfigurationUtil.get(
				SyncServiceConfigurationKeys.
					SYNC_FILE_CHECKSUM_THRESHOLD_SIZE));

	/**
	 * @deprecated As of 1.3.0, with no direct replacement
	 */
	@Deprecated
	public static final int SYNC_FILE_DIFF_CACHE_DELETE_INTERVAL =
		GetterUtil.getInteger(
			SyncServiceConfigurationUtil.get(
				SyncServiceConfigurationKeys.
					SYNC_FILE_DIFF_CACHE_DELETE_INTERVAL));

	public static final boolean SYNC_FILE_DIFF_CACHE_ENABLED =
		GetterUtil.getBoolean(
			SyncServiceConfigurationUtil.get(
				SyncServiceConfigurationKeys.SYNC_FILE_DIFF_CACHE_ENABLED));

	public static final long SYNC_FILE_DIFF_CACHE_EXPIRATION_TIME =
		GetterUtil.getLong(
			SyncServiceConfigurationUtil.get(
				SyncServiceConfigurationKeys.
					SYNC_FILE_DIFF_CACHE_EXPIRATION_TIME));

	public static final boolean SYNC_LAN_ENABLED = GetterUtil.getBoolean(
		SyncServiceConfigurationUtil.get(
			SyncServiceConfigurationKeys.SYNC_LAN_ENABLED));

	public static final String[] SYNC_MAC_PACKAGE_FOLDER_EXTENSIONS =
		GetterUtil.getStringValues(
			SyncServiceConfigurationUtil.getArray(
				SyncServiceConfigurationKeys.
					SYNC_MAC_PACKAGE_FOLDER_EXTENSIONS));

	public static final String[] SYNC_MAC_PACKAGE_METADATA_FILE_NAMES =
		GetterUtil.getStringValues(
			SyncServiceConfigurationUtil.getArray(
				SyncServiceConfigurationKeys.
					SYNC_MAC_PACKAGE_METADATA_FILE_NAMES));

	public static final int SYNC_PAGINATION_DELTA = GetterUtil.getInteger(
		SyncServiceConfigurationUtil.get(
			SyncServiceConfigurationKeys.SYNC_PAGINATION_DELTA));

	public static final boolean SYNC_SERVICES_ENABLED = GetterUtil.getBoolean(
		SyncServiceConfigurationUtil.get(
			SyncServiceConfigurationKeys.SYNC_SERVICES_ENABLED));

	public static final boolean SYNC_VERIFY = GetterUtil.getBoolean(
		SyncServiceConfigurationUtil.get(
			SyncServiceConfigurationKeys.SYNC_VERIFY));

}