/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.internal.messaging;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLSyncEvent;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.kernel.service.DLSyncEventLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.sync.model.SyncDLObject;
import com.liferay.sync.model.impl.SyncDLObjectImpl;
import com.liferay.sync.service.SyncDLObjectLocalService;
import com.liferay.sync.util.SyncUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"destination.name=liferay/document_library_sync_event_processor"}, service={MessageListener.class})
public class DLSyncEventMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(DLSyncEventMessageListener.class);
    private DLFileEntryLocalService _dlFileEntryLocalService;
    private DLFolderLocalService _dlFolderLocalService;
    private DLSyncEventLocalService _dlSyncEventLocalService;
    private SyncDLObjectLocalService _syncDLObjectLocalService;
    @Reference
    private SyncUtil _syncUtil;

    @Activate
    protected void activate() {
        ActionableDynamicQuery actionableDynamicQuery = this._dlSyncEventLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property modifiedTimeProperty = PropertyFactoryUtil.forName((String)"modifiedTime");
                dynamicQuery.add(modifiedTimeProperty.gt((Object)DLSyncEventMessageListener.this._syncDLObjectLocalService.getLatestModifiedTime()));
            }
        });
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<DLSyncEvent>(){

            public void performAction(DLSyncEvent dlSyncEvent) throws PortalException {
                try {
                    DLSyncEventMessageListener.this.processDLSyncEvent(dlSyncEvent.getModifiedTime(), dlSyncEvent.getEvent(), dlSyncEvent.getType(), dlSyncEvent.getTypePK());
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
            }
        });
        try {
            actionableDynamicQuery.performActions();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void doReceive(Message message) throws Exception {
        String event = message.getString("event");
        long modifiedTime = message.getLong("modifiedTime");
        String type = message.getString("type");
        long typePK = message.getLong("typePK");
        try {
            this.processDLSyncEvent(modifiedTime, event, type, typePK);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void processDLSyncEvent(long modifiedTime, String event, String type, long typePK) throws Exception {
        SyncDLObjectImpl syncDLObject;
        block9: {
            DLFolder dlFolder;
            block12: {
                block11: {
                    block10: {
                        block8: {
                            syncDLObject = null;
                            if (!event.equals("delete")) break block8;
                            syncDLObject = new SyncDLObjectImpl();
                            this.setUser(syncDLObject);
                            syncDLObject.setEvent(event);
                            syncDLObject.setType(type);
                            syncDLObject.setTypePK(typePK);
                            break block9;
                        }
                        if (!type.equals("file")) break block10;
                        DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(typePK);
                        if (dlFileEntry == null) {
                            return;
                        }
                        DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
                        if (dlFileVersion.isPending()) {
                            return;
                        }
                        boolean calculateChecksum = false;
                        String checksum = SyncUtil.getChecksum(modifiedTime, typePK);
                        if (checksum == null && !dlFileEntry.isInTrash()) {
                            calculateChecksum = true;
                        }
                        syncDLObject = SyncUtil.toSyncDLObject(dlFileEntry, event, calculateChecksum);
                        if (checksum != null) {
                            syncDLObject.setChecksum(checksum);
                        }
                        if (event.equals("trash")) {
                            this.setUser(syncDLObject);
                        }
                        syncDLObject.setLanTokenKey(SyncUtil.getLanTokenKey(modifiedTime, typePK, false));
                        break block9;
                    }
                    dlFolder = this._dlFolderLocalService.fetchDLFolder(typePK);
                    if (dlFolder == null) break block11;
                    if (SyncUtil.isSupportedFolder(dlFolder)) break block12;
                }
                return;
            }
            syncDLObject = SyncUtil.toSyncDLObject(dlFolder, event);
        }
        syncDLObject.setModifiedTime(modifiedTime);
        SyncUtil.addSyncDLObject(syncDLObject);
    }

    @Reference(unbind="-")
    protected void setDLFileEntryLocalService(DLFileEntryLocalService dlFileEntryLocalService) {
        this._dlFileEntryLocalService = dlFileEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setDLFolderLocalService(DLFolderLocalService dlFolderLocalService) {
        this._dlFolderLocalService = dlFolderLocalService;
    }

    @Reference(unbind="-")
    protected void setDLSyncEventLocalService(DLSyncEventLocalService dlSyncEventLocalService) {
        this._dlSyncEventLocalService = dlSyncEventLocalService;
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    @Reference(unbind="-")
    protected void setSyncDLObjectLocalService(SyncDLObjectLocalService syncDLObjectLocalService) {
        this._syncDLObjectLocalService = syncDLObjectLocalService;
    }

    protected void setUser(SyncDLObject syncDLObject) {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null) {
            User user = permissionChecker.getUser();
            syncDLObject.setUserId(user.getUserId());
            syncDLObject.setUserName(user.getFullName());
        }
    }
}

