/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.sync.util;

import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.sync.model.SyncDevice;

/**
 * @author Shinn Lok
 */
public class SyncDeviceThreadLocal {

	public static SyncDevice getSyncDevice() {
		return _syncDevice.get();
	}

	public static void setSyncDevice(SyncDevice syncDevice) {
		_syncDevice.set(syncDevice);
	}

	private static final ThreadLocal<SyncDevice> _syncDevice =
		new AutoResetThreadLocal<>(
			SyncDeviceThreadLocal.class + "._syncDevice");

}