/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.internal.servlet;

import com.liferay.document.library.kernel.exception.DuplicateFileException;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFileVersionException;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ImageService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import com.liferay.sync.SyncSiteUnavailableException;
import com.liferay.sync.internal.servlet.DownloadServletInputStream;
import com.liferay.sync.model.SyncDLFileVersionDiff;
import com.liferay.sync.model.SyncDevice;
import com.liferay.sync.service.SyncDLFileVersionDiffLocalServiceUtil;
import com.liferay.sync.service.SyncDeviceLocalServiceUtil;
import com.liferay.sync.service.configuration.SyncServiceConfigurationValues;
import com.liferay.sync.util.SyncUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.http.whiteboard.context.path=/sync", "osgi.http.whiteboard.servlet.name=com.liferay.sync.internal.servlet.SyncDownloadServlet", "osgi.http.whiteboard.servlet.pattern=/sync/download/*"}, service={Servlet.class})
public class SyncDownloadServlet
extends HttpServlet {
    private static final String _ERROR_HEADER = "Sync-Error";
    private static final Log _log = LogFactoryUtil.getLog(SyncDownloadServlet.class);
    private DLAppService _dlAppService;
    private DLFileEntryLocalService _dlFileEntryLocalService;
    private DLFileVersionLocalService _dlFileVersionLocalService;
    private GroupLocalService _groupLocalService;
    @Reference
    private Http _http;
    private ImageService _imageService;
    @Reference
    private Portal _portal;
    @Reference
    private SyncUtil _syncUtil;
    private UserLocalService _userLocalService;

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block18: {
            try {
                String fileUuid;
                long groupId;
                User user;
                block20: {
                    block19: {
                        SyncDevice syncDevice;
                        HttpSession session = request.getSession();
                        if (PortalSessionThreadLocal.getHttpSession() == null) {
                            PortalSessionThreadLocal.setHttpSession((HttpSession)session);
                        }
                        user = this._portal.getUser(request);
                        String syncUuid = request.getHeader("Sync-UUID");
                        if (syncUuid != null && (syncDevice = SyncDeviceLocalServiceUtil.fetchSyncDeviceByUuidAndCompanyId((String)syncUuid, (long)user.getCompanyId())) != null) {
                            syncDevice.checkStatus();
                        }
                        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
                        PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
                        String path = this._http.fixPath(request.getPathInfo());
                        String[] pathArray = StringUtil.split((String)path, (char)'/');
                        if (pathArray[0].equals("image")) {
                            long imageId = GetterUtil.getLong((String)pathArray[1]);
                            this.sendImage(response, imageId);
                            break block18;
                        }
                        if (pathArray[0].equals("zip")) {
                            String zipFileIds = ParamUtil.get((HttpServletRequest)request, (String)"zipFileIds", (String)"");
                            if (Validator.isNull((String)zipFileIds)) {
                                throw new IllegalArgumentException("Missing parameter zipFileIds");
                            }
                            JSONArray zipFileIdsJSONArray = JSONFactoryUtil.createJSONArray((String)zipFileIds);
                            this.sendZipFile(response, user.getUserId(), zipFileIdsJSONArray);
                            break block18;
                        }
                        if (pathArray[0].equals("zipfolder")) {
                            long repositoryId = ParamUtil.getLong((HttpServletRequest)request, (String)"repositoryId");
                            long folderId = ParamUtil.getLong((HttpServletRequest)request, (String)"folderId");
                            if (repositoryId == 0L) {
                                throw new IllegalArgumentException("Missing parameter repositoryId");
                            }
                            if (folderId == 0L) {
                                throw new IllegalArgumentException("Missing parameter folderId");
                            }
                            this.sendZipFolder(response, user.getUserId(), repositoryId, folderId);
                            break block18;
                        }
                        groupId = GetterUtil.getLong((String)pathArray[0]);
                        fileUuid = pathArray[1];
                        Group group = this._groupLocalService.fetchGroup(groupId);
                        if (group == null) break block19;
                        if (SyncUtil.isSyncEnabled(group)) break block20;
                    }
                    response.setHeader(_ERROR_HEADER, SyncSiteUnavailableException.class.getName());
                    ServletResponseUtil.write((HttpServletResponse)response, (byte[])new byte[0]);
                    return;
                }
                boolean patch = ParamUtil.getBoolean((HttpServletRequest)request, (String)"patch");
                if (patch) {
                    this.sendPatch(request, response, user.getUserId(), groupId, fileUuid);
                } else {
                    this.sendFile(request, response, user.getUserId(), groupId, fileUuid);
                }
            }
            catch (NoSuchFileEntryException nsfee) {
                this._portal.sendError(404, (Exception)((Object)nsfee), request, response);
            }
            catch (NoSuchFileVersionException nsfve) {
                this._portal.sendError(404, (Exception)((Object)nsfve), request, response);
            }
            catch (Exception e) {
                this._portal.sendError(e, request, response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addZipFolderEntry(long userId, long repositoryId, long folderId, String folderPath, ZipWriter zipWriter) throws Exception {
        List fileEntries = this._dlAppService.getFileEntries(repositoryId, folderId);
        for (FileEntry fileEntry : fileEntries) {
            InputStream inputStream = null;
            try {
                inputStream = this._dlFileEntryLocalService.getFileAsStream(userId, fileEntry.getFileEntryId(), fileEntry.getVersion(), false);
                String filePath = folderPath + fileEntry.getTitle();
                zipWriter.addEntry(filePath, inputStream);
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        }
        List childFolders = this._dlAppService.getFolders(repositoryId, folderId);
        for (Folder childFolder : childFolders) {
            String childFolderPath = folderPath + childFolder.getName() + "/";
            this.addZipFolderEntry(userId, repositoryId, childFolder.getFolderId(), childFolderPath, zipWriter);
        }
    }

    protected File getDeltaFile(long userId, long fileEntryId, long sourceVersionId, long targetVersionId) throws Exception {
        DLFileVersion sourceDLFileVersion = this._dlFileVersionLocalService.getDLFileVersion(sourceVersionId);
        File sourceFile = this._dlFileEntryLocalService.getFile(userId, fileEntryId, sourceDLFileVersion.getVersion(), false);
        DLFileVersion targetDLFileVersion = this._dlFileVersionLocalService.getDLFileVersion(targetVersionId);
        File targetFile = this._dlFileEntryLocalService.getFile(userId, fileEntryId, targetDLFileVersion.getVersion(), false);
        return SyncUtil.getFileDelta(sourceFile, targetFile);
    }

    protected DownloadServletInputStream getFileDownloadServletInputStream(long userId, long groupId, String uuid, String version, long versionId) throws Exception {
        FileEntry fileEntry = this._dlAppService.getFileEntryByUuidAndGroupId(uuid, groupId);
        if (fileEntry.isInTrash()) {
            throw new NoSuchFileEntryException();
        }
        if (Validator.isNull((String)version)) {
            InputStream inputStream = this._dlFileEntryLocalService.getFileAsStream(userId, fileEntry.getFileEntryId(), fileEntry.getVersion(), false);
            return new DownloadServletInputStream(inputStream, fileEntry.getFileName(), fileEntry.getMimeType(), fileEntry.getSize());
        }
        if (versionId > 0L) {
            DLFileVersion dlFileVersion = this._dlFileVersionLocalService.fetchDLFileVersion(versionId);
            return new DownloadServletInputStream(dlFileVersion.getContentStream(false), dlFileVersion.getFileName(), dlFileVersion.getMimeType(), dlFileVersion.getSize());
        }
        FileVersion fileVersion = fileEntry.getFileVersion(version);
        return new DownloadServletInputStream(fileVersion.getContentStream(false), fileVersion.getFileName(), fileVersion.getMimeType(), fileVersion.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DownloadServletInputStream getPatchDownloadServletInputStream(long userId, long groupId, String uuid, long sourceVersionId, long targetVersionId) throws Exception {
        DownloadServletInputStream downloadServletInputStream;
        FileEntry fileEntry = this._dlAppService.getFileEntryByUuidAndGroupId(uuid, groupId);
        if (fileEntry.isInTrash()) {
            throw new NoSuchFileEntryException();
        }
        if (!SyncServiceConfigurationValues.SYNC_FILE_DIFF_CACHE_ENABLED) {
            DownloadServletInputStream downloadServletInputStream2;
            File deltaFile = null;
            try {
                deltaFile = this.getDeltaFile(userId, fileEntry.getFileEntryId(), sourceVersionId, targetVersionId);
                downloadServletInputStream2 = new DownloadServletInputStream(new FileInputStream(deltaFile), deltaFile.length());
            }
            catch (Throwable throwable) {
                FileUtil.delete(deltaFile);
                throw throwable;
            }
            FileUtil.delete((File)deltaFile);
            return downloadServletInputStream2;
        }
        SyncDLFileVersionDiff syncDLFileVersionDiff = SyncDLFileVersionDiffLocalServiceUtil.fetchSyncDLFileVersionDiff((long)fileEntry.getFileEntryId(), (long)sourceVersionId, (long)targetVersionId);
        if (syncDLFileVersionDiff != null) {
            SyncDLFileVersionDiffLocalServiceUtil.refreshExpirationDate((long)syncDLFileVersionDiff.getSyncDLFileVersionDiffId());
            FileEntry dataFileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)syncDLFileVersionDiff.getDataFileEntryId());
            return new DownloadServletInputStream(dataFileEntry.getContentStream(), dataFileEntry.getSize());
        }
        File deltaFile = null;
        try {
            block9: {
                deltaFile = this.getDeltaFile(userId, fileEntry.getFileEntryId(), sourceVersionId, targetVersionId);
                try {
                    SyncDLFileVersionDiffLocalServiceUtil.addSyncDLFileVersionDiff((long)fileEntry.getFileEntryId(), (long)sourceVersionId, (long)targetVersionId, (File)deltaFile);
                }
                catch (DuplicateFileException dfe) {
                    if (!_log.isDebugEnabled()) break block9;
                    _log.debug((Object)dfe, (Throwable)dfe);
                }
            }
            downloadServletInputStream = new DownloadServletInputStream(new FileInputStream(deltaFile), deltaFile.length());
        }
        catch (Throwable throwable) {
            FileUtil.delete(deltaFile);
            throw throwable;
        }
        FileUtil.delete((File)deltaFile);
        return downloadServletInputStream;
    }

    protected void processException(String zipFileId, String exception, JSONObject errorsJSONObject) {
        JSONObject exceptionJSONObject = JSONFactoryUtil.createJSONObject();
        exceptionJSONObject.put("exception", exception);
        errorsJSONObject.put(zipFileId, exceptionJSONObject);
    }

    protected void sendFile(HttpServletRequest request, HttpServletResponse response, long userId, long groupId, String uuid) throws Exception {
        String version = ParamUtil.getString((HttpServletRequest)request, (String)"version");
        long versionId = ParamUtil.getLong((HttpServletRequest)request, (String)"versionId");
        DownloadServletInputStream downloadServletInputStream = this.getFileDownloadServletInputStream(userId, groupId, uuid, version, versionId);
        if (request.getHeader("Range") != null) {
            ServletResponseUtil.sendFileWithRangeHeader((HttpServletRequest)request, (HttpServletResponse)response, (String)downloadServletInputStream.getFileName(), (InputStream)downloadServletInputStream, (long)downloadServletInputStream.getSize(), (String)downloadServletInputStream.getMimeType());
        } else {
            ServletResponseUtil.write((HttpServletResponse)response, (InputStream)downloadServletInputStream, (long)downloadServletInputStream.getSize());
        }
    }

    protected void sendImage(HttpServletResponse response, long imageId) throws Exception {
        Image image;
        String type;
        User user = this._userLocalService.fetchUser(imageId);
        if (user != null) {
            imageId = user.getPortraitId();
        }
        if (!(type = (image = this._imageService.getImage(imageId)).getType()).equals("na")) {
            String contentType = MimeTypesUtil.getExtensionContentType((String)type);
            response.setContentType(contentType);
        }
        ServletResponseUtil.write((HttpServletResponse)response, (byte[])image.getTextObj());
    }

    protected void sendPatch(HttpServletRequest request, HttpServletResponse response, long userId, long groupId, String uuid) throws Exception {
        long sourceVersionId = ParamUtil.getLong((HttpServletRequest)request, (String)"sourceVersionId", (long)0L);
        long targetVersionId = ParamUtil.getLong((HttpServletRequest)request, (String)"targetVersionId", (long)0L);
        DownloadServletInputStream downloadServletInputStream = this.getPatchDownloadServletInputStream(userId, groupId, uuid, sourceVersionId, targetVersionId);
        ServletResponseUtil.write((HttpServletResponse)response, (InputStream)downloadServletInputStream, (long)downloadServletInputStream.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendZipFile(HttpServletResponse response, long userId, JSONArray zipFileIdsJSONArray) throws Exception {
        ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
        JSONObject errorsJSONObject = JSONFactoryUtil.createJSONObject();
        for (int i = 0; i < zipFileIdsJSONArray.length(); ++i) {
            DownloadServletInputStream inputStream;
            block9: {
                String zipFileId;
                long groupId;
                JSONObject zipObjectJSONObject;
                block11: {
                    block10: {
                        zipObjectJSONObject = zipFileIdsJSONArray.getJSONObject(i);
                        groupId = zipObjectJSONObject.getLong("groupId");
                        zipFileId = zipObjectJSONObject.getString("zipFileId");
                        Group group = this._groupLocalService.fetchGroup(groupId);
                        if (group == null) break block10;
                        if (SyncUtil.isSyncEnabled(group)) break block11;
                    }
                    this.processException(zipFileId, SyncSiteUnavailableException.class.getName(), errorsJSONObject);
                    continue;
                }
                inputStream = null;
                try {
                    String uuid = zipObjectJSONObject.getString("uuid");
                    if (zipObjectJSONObject.getBoolean("patch")) {
                        long sourceVersionId = zipObjectJSONObject.getLong("sourceVersionId", 0L);
                        long targetVersionId = zipObjectJSONObject.getLong("targetVersionId", 0L);
                        inputStream = this.getPatchDownloadServletInputStream(userId, groupId, uuid, sourceVersionId, targetVersionId);
                        zipWriter.addEntry(zipFileId, (InputStream)inputStream);
                        break block9;
                    }
                    inputStream = this.getFileDownloadServletInputStream(userId, groupId, uuid, zipObjectJSONObject.getString("version"), zipObjectJSONObject.getLong("versionId"));
                    zipWriter.addEntry(zipFileId, (InputStream)inputStream);
                }
                catch (Exception e) {
                    try {
                        Class<?> clazz = e.getClass();
                        this.processException(zipFileId, clazz.getName(), errorsJSONObject);
                    }
                    catch (Throwable throwable) {
                        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                        throw throwable;
                    }
                    StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                    continue;
                }
            }
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            continue;
        }
        zipWriter.addEntry("errors.json", errorsJSONObject.toString());
        File file = zipWriter.getFile();
        ServletResponseUtil.write((HttpServletResponse)response, (InputStream)new FileInputStream(file), (long)file.length());
    }

    protected void sendZipFolder(HttpServletResponse response, long userId, long repositoryId, long folderId) throws Exception {
        ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
        this.addZipFolderEntry(userId, repositoryId, folderId, "", zipWriter);
        File file = zipWriter.getFile();
        ServletResponseUtil.write((HttpServletResponse)response, (InputStream)new FileInputStream(file), (long)file.length());
    }

    @Reference(unbind="-")
    protected void setDLAppService(DLAppService dlAppService) {
        this._dlAppService = dlAppService;
    }

    @Reference(unbind="-")
    protected void setDlFileEntryLocalService(DLFileEntryLocalService dlFileEntryLocalService) {
        this._dlFileEntryLocalService = dlFileEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setDlFileVersionLocalService(DLFileVersionLocalService dlFileVersionLocalService) {
        this._dlFileVersionLocalService = dlFileVersionLocalService;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setImageService(ImageService imageService) {
        this._imageService = imageService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

