/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.sync.internal.jsonws;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.sync.service.SyncDLObjectService;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Shinn Lok
 */
@Component(
	immediate = true,
	property = {
		"json.web.service.context.name=sync-web",
		"json.web.service.context.path=SyncDLObject"
	},
	service = SyncDLObject.class
)
@JSONWebService
public class SyncDLObject {

	public Object getSyncContext() throws PortalException {
		return _syncDLObjectService.getSyncContext();
	}

	@Reference(unbind = "-")
	protected void setGroupLocalService(
		SyncDLObjectService syncDLObjectService) {

		_syncDLObjectService = syncDLObjectService;
	}

	private SyncDLObjectService _syncDLObjectService;

}