/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.service.persistence.impl;

import com.liferay.portal.dao.orm.custom.sql.CustomSQLUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.sync.model.SyncDLObject;
import com.liferay.sync.model.impl.SyncDLObjectImpl;
import com.liferay.sync.service.persistence.SyncDLObjectFinder;
import com.liferay.sync.service.persistence.impl.SyncDLObjectFinderBaseImpl;
import java.util.Collections;
import java.util.List;

public class SyncDLObjectFinderImpl
extends SyncDLObjectFinderBaseImpl
implements SyncDLObjectFinder {
    public static final String FIND_BY_MODIFIED_TIME = SyncDLObjectFinder.class.getName() + ".findByModifiedTime";
    public static final String FIND_BY_TYPE_PKS = SyncDLObjectFinder.class.getName() + ".findByTypePKs";

    public List<Long> filterFindByR_U_T(long groupId, long userId, long[] typePKs) {
        if (ArrayUtil.isEmpty((long[])typePKs)) {
            return Collections.emptyList();
        }
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get(((Object)((Object)this)).getClass(), (String)FIND_BY_TYPE_PKS);
            sql = StringUtil.replace((String)sql, (String[])new String[]{"[$TYPE_PKS$]", "[$ROLE_IDS_OR_OWNER_ID$]"}, (String[])new String[]{this.getTypePKsSQL(typePKs), this.getRoleOwnerIdsSQL(groupId, userId)});
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("primKey", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)sqlQuery);
            qPos.add(CompanyThreadLocal.getCompanyId());
            qPos.add(4);
            List list = sqlQuery.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<SyncDLObject> findByModifiedTime(long modifiedTime, long repositoryId, long parentFolderId, String type, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get(((Object)((Object)this)).getClass(), (String)FIND_BY_MODIFIED_TIME);
            if (modifiedTime <= 0L) {
                sql = StringUtil.replace((String)sql, (String)"(SyncDLObject.modifiedTime > ?) AND", (String)"");
            }
            if (parentFolderId == 0L) {
                sql = StringUtil.replace((String)sql, (String)"AND (SyncDLObject.treePath LIKE ?)", (String)"");
            }
            if (type == null) {
                sql = StringUtil.replace((String)sql, (String)"AND (SyncDLObject.type_ = ?)", (String)"");
            }
            if (start == -1 && end == -1) {
                sql = CustomSQLUtil.removeOrderBy((String)sql);
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("SyncDLObject", SyncDLObjectImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)sqlQuery);
            if (modifiedTime > 0L) {
                qPos.add(modifiedTime);
            }
            qPos.add(repositoryId);
            if (parentFolderId != 0L) {
                qPos.add("%/" + parentFolderId + "/%");
            }
            if (type != null) {
                qPos.add(type);
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getRoleOwnerIdsSQL(long groupId, long userId) {
        StringBundler sb = new StringBundler(8);
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        long[] roleIds = permissionChecker.getRoleIds(userId, groupId);
        sb.append("(");
        if (roleIds.length != 0) {
            sb.append("roleId IN (");
            sb.append(StringUtil.merge((long[])roleIds));
            sb.append(")");
            sb.append(" OR ");
        }
        sb.append("ownerId = ");
        sb.append(userId);
        sb.append(")");
        return sb.toString();
    }

    protected String getTypePKsSQL(long[] typePKs) {
        StringBundler sb = new StringBundler(typePKs.length * 4 + 1);
        sb.append("primKey IN (");
        for (int i = 0; i < typePKs.length; ++i) {
            sb.append("CAST_TEXT(");
            sb.append(String.valueOf(typePKs[i]).trim());
            sb.append(")");
            if (i + 1 == typePKs.length) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

