/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.sync.util.comparator;

import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.sync.model.SyncDLObject;

/**
 * @author Shinn Lok
 */
public class SyncDLObjectModifiedTimeComparator
	extends OrderByComparator<SyncDLObject> {

	public static final String ORDER_BY_ASC = "SyncDLObject.modifiedTime ASC";

	public static final String ORDER_BY_DESC = "SyncDLObject.modifiedTime DESC";

	public static final String[] ORDER_BY_FIELDS = {"modifiedTime"};

	public SyncDLObjectModifiedTimeComparator() {
		this(true);
	}

	public SyncDLObjectModifiedTimeComparator(boolean ascending) {
		_ascending = ascending;
	}

	@Override
	public int compare(SyncDLObject syncDLObject1, SyncDLObject syncDLObject2) {
		long modifiedTime1 = syncDLObject1.getModifiedTime();
		long modifiedTime2 = syncDLObject2.getModifiedTime();

		int value = 0;

		if (modifiedTime1 < modifiedTime2) {
			value = -1;
		}
		else if (modifiedTime1 > modifiedTime2) {
			value = 1;
		}

		if (_ascending) {
			return value;
		}
		else {
			return -value;
		}
	}

	@Override
	public String getOrderBy() {
		if (_ascending) {
			return ORDER_BY_ASC;
		}
		else {
			return ORDER_BY_DESC;
		}
	}

	@Override
	public String[] getOrderByFields() {
		return ORDER_BY_FIELDS;
	}

	@Override
	public boolean isAscending() {
		return _ascending;
	}

	private final boolean _ascending;

}