/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.sync.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.sync.constants.SyncDeviceConstants;
import com.liferay.sync.model.SyncDevice;
import com.liferay.sync.service.base.SyncDeviceLocalServiceBaseImpl;

import java.util.Date;
import java.util.List;

/**
 * @author Shinn Lok
 */
public class SyncDeviceLocalServiceImpl extends SyncDeviceLocalServiceBaseImpl {

	@Override
	public SyncDevice addSyncDevice(
			long userId, String type, long buildNumber, String hostname,
			int featureSet)
		throws PortalException {

		User user = userLocalService.getUser(userId);
		Date now = new Date();

		long syncDeviceId = counterLocalService.increment();

		SyncDevice syncDevice = syncDevicePersistence.create(syncDeviceId);

		syncDevice.setCompanyId(user.getCompanyId());
		syncDevice.setUserId(user.getUserId());
		syncDevice.setUserName(user.getFullName());
		syncDevice.setCreateDate(now);
		syncDevice.setModifiedDate(now);
		syncDevice.setType(type);
		syncDevice.setBuildNumber(buildNumber);
		syncDevice.setFeatureSet(featureSet);
		syncDevice.setHostname(hostname);
		syncDevice.setStatus(SyncDeviceConstants.STATUS_ACTIVE);

		syncDevicePersistence.update(syncDevice);

		return syncDevice;
	}

	@Override
	public List<SyncDevice> getSyncDevices(
			long userId, int start, int end,
			OrderByComparator orderByComparator)
		throws PortalException {

		return syncDevicePersistence.findByUserId(
			userId, start, end, orderByComparator);
	}

	@Override
	public List<SyncDevice> search(
		long companyId, String keywords, int start, int end,
		OrderByComparator<SyncDevice> orderByComparator) {

		return syncDevicePersistence.findByC_U(
			companyId, StringUtil.quote(keywords, StringPool.PERCENT), start,
			end, orderByComparator);
	}

	@Override
	public void updateStatus(long syncDeviceId, int status)
		throws PortalException {

		SyncDevice syncDevice = syncDevicePersistence.findByPrimaryKey(
			syncDeviceId);

		syncDevice.setStatus(status);

		syncDevicePersistence.update(syncDevice);
	}

	@Override
	public SyncDevice updateSyncDevice(
			long syncDeviceId, String type, long buildNumber, int featureSet,
			String hostname, int status)
		throws PortalException {

		SyncDevice syncDevice = syncDevicePersistence.findByPrimaryKey(
			syncDeviceId);

		syncDevice.setModifiedDate(new Date());
		syncDevice.setType(type);
		syncDevice.setBuildNumber(buildNumber);
		syncDevice.setFeatureSet(featureSet);
		syncDevice.setHostname(hostname);
		syncDevice.setStatus(status);

		syncDevicePersistence.update(syncDevice);

		return syncDevice;
	}

}