/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.sync.service.configuration;

/**
 * @author Dennis Ju
 */
public class SyncServiceConfigurationKeys {

	public static final String SYNC_ALLOW_USER_PERSONAL_SITES =
		"sync.allow.user.personal.sites";

	public static final String SYNC_CLIENT_AUTHENTICATION_RETRY_INTERVAL =
		"sync.client.authentication.retry.interval";

	public static final String SYNC_CLIENT_BATCH_FILE_MAX_SIZE =
		"sync.client.batch.file.max.size";

	public static final String SYNC_CLIENT_FORCE_SECURITY_MODE =
		"sync.client.force.security.mode";

	public static final String SYNC_CLIENT_MAX_CONNECTIONS =
		"sync.client.max.connections";

	public static final String SYNC_CLIENT_MAX_DOWNLOAD_RATE =
		"sync.client.max.download.rate";

	public static final String SYNC_CLIENT_MAX_UPLOAD_RATE =
		"sync.client.max.upload.rate";

	public static final String SYNC_CLIENT_MIN_BUILD_ANDROID =
		"sync.client.min.build.android";

	public static final String SYNC_CLIENT_MIN_BUILD_DESKTOP =
		"sync.client.min.build.desktop";

	public static final String SYNC_CLIENT_MIN_BUILD_IOS =
		"sync.client.min.build.ios";

	public static final String SYNC_CLIENT_POLL_INTERVAL =
		"sync.client.poll.interval";

	public static final String SYNC_FILE_CHECKSUM_THRESHOLD_SIZE =
		"sync.file.checksum.threshold.size";

	/**
	 * @deprecated As of 1.3.0, with no direct replacement
	 */
	@Deprecated
	public static final String SYNC_FILE_DIFF_CACHE_DELETE_INTERVAL =
		"sync.file.diff.cache.delete.interval";

	public static final String SYNC_FILE_DIFF_CACHE_ENABLED =
		"sync.file.diff.cache.enabled";

	public static final String SYNC_FILE_DIFF_CACHE_EXPIRATION_TIME =
		"sync.file.diff.cache.expiration.time";

	public static final String SYNC_LAN_ENABLED = "sync.lan.enabled";

	public static final String SYNC_MAC_PACKAGE_FOLDER_EXTENSIONS =
		"sync.mac.package.folder.extensions";

	public static final String SYNC_MAC_PACKAGE_METADATA_FILE_NAMES =
		"sync.mac.package.metadata.file.names";

	public static final String SYNC_PAGINATION_DELTA = "sync.pagination.delta";

	public static final String SYNC_SERVICES_ENABLED = "sync.services.enabled";

	public static final String SYNC_VERIFY = "sync.verify";

}