/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.sync.model.impl;

import aQute.bnd.annotation.ProviderType;

import com.liferay.sync.model.SyncDLObject;
import com.liferay.sync.service.SyncDLObjectLocalServiceUtil;

/**
 * The extended model base implementation for the SyncDLObject service. Represents a row in the &quot;SyncDLObject&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SyncDLObjectImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see SyncDLObjectImpl
 * @see SyncDLObject
 * @generated
 */
@ProviderType
public abstract class SyncDLObjectBaseImpl extends SyncDLObjectModelImpl
	implements SyncDLObject {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a sync dl object model instance should use the {@link SyncDLObject} interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			SyncDLObjectLocalServiceUtil.addSyncDLObject(this);
		}
		else {
			SyncDLObjectLocalServiceUtil.updateSyncDLObject(this);
		}
	}

	@Override
	public void updateTreePath(String treePath) {
		SyncDLObject syncDLObject = this;

		syncDLObject.setTreePath(treePath);

		SyncDLObjectLocalServiceUtil.updateSyncDLObject(syncDLObject);
	}
}