/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.security.internal.service.access.policy;

import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalService;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={})
public class SyncSAPEntryActivator {
    public static final Object[][] SAP_ENTRY_OBJECT_ARRAYS = new Object[][]{{"SYNC_DEFAULT", "com.liferay.sync.service.SyncDLObjectService#getSyncContext", true}, {"SYNC_TOKEN", "com.liferay.sync.service.*", false}};
    private static final Log _log = LogFactoryUtil.getLog(SyncSAPEntryActivator.class);
    @Reference(unbind="-")
    private SAPEntryLocalService _sapEntryLocalService;
    private ServiceRegistration<PortalInstanceLifecycleListener> _serviceRegistration;
    @Reference(unbind="-")
    private UserLocalService _userLocalService;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceRegistration = bundleContext.registerService(PortalInstanceLifecycleListener.class, (Object)new PolicyPortalInstanceLifecycleListener(), null);
    }

    protected void addSAPEntry(long companyId) throws PortalException {
        for (Object[] sapEntryObjectArray : SAP_ENTRY_OBJECT_ARRAYS) {
            String name = String.valueOf(sapEntryObjectArray[0]);
            SAPEntry sapEntry = this._sapEntryLocalService.fetchSAPEntry(companyId, name);
            if (sapEntry != null) continue;
            String allowedServiceSignatures = String.valueOf(sapEntryObjectArray[1]);
            boolean defaultSAPEntry = GetterUtil.getBoolean((Object)sapEntryObjectArray[2]);
            this._sapEntryLocalService.addSAPEntry(this._userLocalService.getDefaultUserId(companyId), allowedServiceSignatures, defaultSAPEntry, true, name, (Map)HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)name).build(), new ServiceContext());
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }

    private class PolicyPortalInstanceLifecycleListener
    extends BasePortalInstanceLifecycleListener {
        private PolicyPortalInstanceLifecycleListener() {
        }

        public void portalInstanceRegistered(Company company) throws Exception {
            try {
                SyncSAPEntryActivator.this.addSAPEntry(company.getCompanyId());
            }
            catch (PortalException portalException) {
                _log.error((Object)("Unable to add service access policy entry for company " + company.getCompanyId()), (Throwable)portalException);
            }
        }
    }
}

