/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.subscription.internal.messaging;

import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.subscription.service.SubscriptionLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"destination.name=liferay/subscription_clean_up"}, service={MessageListener.class})
public class CleanUpSubscriptionMessageListener
extends BaseMessageListener {
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;

    protected void doReceive(Message message) throws Exception {
        long[] groupIds = (long[])message.get("groupIds");
        if (groupIds == null) {
            long[] userIds = (long[])message.get("userIds");
            long groupId = (Long)message.get("groupId");
            for (long userId : userIds) {
                this._subscriptionLocalService.deleteSubscriptions(userId, groupId);
            }
        } else {
            long userId = (Long)message.get("userId");
            for (long groupId : groupIds) {
                this._subscriptionLocalService.deleteSubscriptions(userId, groupId);
            }
        }
    }
}

