/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.subscription.internal.service;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.WorkflowInstanceLink;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalServiceWrapper;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.subscription.service.SubscriptionLocalService;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Adolfo Pérez
 */
@Component(immediate = true, service = ServiceWrapper.class)
public class SubscriptionWorkflowInstanceLinkLocalServiceWrapper
	extends WorkflowInstanceLinkLocalServiceWrapper {

	public SubscriptionWorkflowInstanceLinkLocalServiceWrapper() {
		super(null);
	}

	public SubscriptionWorkflowInstanceLinkLocalServiceWrapper(
		WorkflowInstanceLinkLocalService workflowInstanceLinkLocalService) {

		super(workflowInstanceLinkLocalService);
	}

	@Override
	public WorkflowInstanceLink deleteWorkflowInstanceLink(
			WorkflowInstanceLink workflowInstanceLink)
		throws PortalException {

		WorkflowInstanceLink deletedWorkflowInstanceLink =
			super.deleteWorkflowInstanceLink(workflowInstanceLink);

		if (deletedWorkflowInstanceLink == null) {
			return null;
		}

		_subscriptionLocalService.deleteSubscriptions(
			workflowInstanceLink.getCompanyId(),
			WorkflowInstance.class.getName(),
			workflowInstanceLink.getWorkflowInstanceId());

		return deletedWorkflowInstanceLink;
	}

	@Reference
	private SubscriptionLocalService _subscriptionLocalService;

}