/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.subscription.internal.messaging;

import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.DestinationNames;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.subscription.service.SubscriptionLocalService;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Adolfo Pérez
 */
@Component(
	immediate = true,
	property = "destination.name=" + DestinationNames.SUBSCRIPTION_CLEAN_UP,
	service = MessageListener.class
)
public class CleanUpSubscriptionMessageListener extends BaseMessageListener {

	@Override
	protected void doReceive(Message message) throws Exception {
		long[] groupIds = (long[])message.get("groupIds");

		if (groupIds == null) {
			long[] userIds = (long[])message.get("userIds");

			long groupId = (Long)message.get("groupId");

			for (long userId : userIds) {
				_subscriptionLocalService.deleteSubscriptions(userId, groupId);
			}
		}
		else {
			long userId = (Long)message.get("userId");

			for (long groupId : groupIds) {
				_subscriptionLocalService.deleteSubscriptions(userId, groupId);
			}
		}
	}

	@Reference
	private SubscriptionLocalService _subscriptionLocalService;

}