/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.subscription.internal.model.listener;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.subscription.service.SubscriptionLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class SubscriptionPortletPreferencesModelListener
extends BaseModelListener<PortletPreferences> {
    private static final Log _log = LogFactoryUtil.getLog(SubscriptionPortletPreferencesModelListener.class);
    private SubscriptionLocalService _subscriptionLocalService;

    public void onAfterRemove(PortletPreferences portletPreferences) {
        this.deleteSubscriptions(portletPreferences);
    }

    protected void deleteSubscriptions(PortletPreferences portletPreferences) {
        if (portletPreferences == null) {
            return;
        }
        try {
            this._subscriptionLocalService.deleteSubscriptions(portletPreferences.getCompanyId(), portletPreferences.getModelClassName(), portletPreferences.getPortletPreferencesId());
        }
        catch (Exception e) {
            _log.error((Object)"Unable to delete subscriptions", (Throwable)e);
        }
    }

    @Reference(unbind="-")
    protected void setSubscriptionLocalService(SubscriptionLocalService subscriptionLocalService) {
        this._subscriptionLocalService = subscriptionLocalService;
    }
}

