/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.style.book.internal.frontend.css.variables;

import com.liferay.frontend.css.variables.ScopedCSSVariables;
import com.liferay.frontend.css.variables.ScopedCSSVariablesProvider;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.style.book.model.StyleBookEntry;
import com.liferay.style.book.util.DefaultStyleBookEntryUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ScopedCSSVariablesProvider.class})
public class StyleBookScopedCSSVariablesProvider
implements ScopedCSSVariablesProvider {
    private static final Log _log = LogFactoryUtil.getLog(StyleBookScopedCSSVariablesProvider.class);
    @Reference
    private JSONFactory _jsonFactory;

    public Collection<ScopedCSSVariables> getScopedCSSVariablesCollection(HttpServletRequest httpServletRequest) {
        final String frontendTokensValues = this._getFrontendTokensValues(httpServletRequest);
        if (Validator.isNull((String)frontendTokensValues)) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new ScopedCSSVariables(){

            public Map<String, String> getCSSVariables() {
                HashMap<String, String> cssVariables;
                block3: {
                    cssVariables = new HashMap<String, String>();
                    try {
                        JSONObject frontendTokensValuesJSONObject = StyleBookScopedCSSVariablesProvider.this._jsonFactory.createJSONObject(frontendTokensValues);
                        Iterator iterator = frontendTokensValuesJSONObject.keys();
                        while (iterator.hasNext()) {
                            String key = (String)iterator.next();
                            JSONObject frontendTokenValueJSONObject = frontendTokensValuesJSONObject.getJSONObject(key);
                            cssVariables.put(frontendTokenValueJSONObject.getString("cssVariableMapping"), frontendTokenValueJSONObject.getString("value"));
                        }
                    }
                    catch (JSONException jsonException) {
                        if (!_log.isDebugEnabled()) break block3;
                        _log.debug((Object)"Unable to parse JSON", (Throwable)jsonException);
                    }
                }
                return cssVariables;
            }

            public String getScope() {
                return ":root";
            }
        });
    }

    private String _getFrontendTokensValues(HttpServletRequest httpServletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Group group = themeDisplay.getSiteGroup();
        Layout layout = themeDisplay.getLayout();
        boolean styleBookEntryPreview = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"styleBookEntryPreview");
        if (group.isControlPanel() || layout.isTypeControlPanel() || styleBookEntryPreview) {
            return "";
        }
        StyleBookEntry styleBookEntry = DefaultStyleBookEntryUtil.getDefaultStyleBookEntry((Layout)themeDisplay.getLayout());
        if (styleBookEntry == null) {
            return "";
        }
        return styleBookEntry.getFrontendTokensValues();
    }
}

