/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.style.book.service.impl;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.frontend.token.definition.FrontendTokenDefinition;
import com.liferay.frontend.token.definition.FrontendTokenDefinitionRegistry;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.style.book.exception.DuplicateStyleBookEntryKeyException;
import com.liferay.style.book.exception.StyleBookEntryNameException;
import com.liferay.style.book.model.StyleBookEntry;
import com.liferay.style.book.service.base.StyleBookEntryLocalServiceBaseImpl;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.style.book.model.StyleBookEntry"}, service={AopService.class})
public class StyleBookEntryLocalServiceImpl
extends StyleBookEntryLocalServiceBaseImpl {
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private FrontendTokenDefinitionRegistry _frontendTokenDefinitionRegistry;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public StyleBookEntry addStyleBookEntry(String externalReferenceCode, long userId, long groupId, boolean defaultStyleBookEntry, String frontendTokensValues, String name, String styleBookEntryKey, String themeId, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        long companyId = user.getCompanyId();
        if (serviceContext != null) {
            companyId = serviceContext.getCompanyId();
        } else {
            serviceContext = new ServiceContext();
        }
        this._validate(name);
        styleBookEntryKey = Validator.isNull((String)styleBookEntryKey) ? this.generateStyleBookEntryKey(groupId, name) : this._getStyleBookEntryKey(styleBookEntryKey);
        this._validateStyleBookEntryKey(groupId, styleBookEntryKey);
        StyleBookEntry styleBookEntry = this.create();
        String uuid = serviceContext.getUuid();
        if (Validator.isNotNull((String)uuid)) {
            styleBookEntry.setUuid(uuid);
        }
        styleBookEntry.setExternalReferenceCode(externalReferenceCode);
        styleBookEntry.setGroupId(groupId);
        styleBookEntry.setCompanyId(companyId);
        styleBookEntry.setUserId(user.getUserId());
        styleBookEntry.setUserName(user.getFullName());
        styleBookEntry.setCreateDate(serviceContext.getCreateDate(new Date()));
        styleBookEntry.setDefaultStyleBookEntry(defaultStyleBookEntry);
        styleBookEntry.setFrontendTokensValues(frontendTokensValues);
        styleBookEntry.setName(name);
        styleBookEntry.setStyleBookEntryKey(styleBookEntryKey);
        if (FeatureFlagManagerUtil.isEnabled((String)"LPD-30204")) {
            styleBookEntry.setThemeId(themeId);
        } else {
            LayoutSet publicLayoutSet = this._layoutSetLocalService.getLayoutSet(groupId, false);
            FrontendTokenDefinition frontendTokenDefinition = this._frontendTokenDefinitionRegistry.getFrontendTokenDefinition(publicLayoutSet);
            if (frontendTokenDefinition != null) {
                styleBookEntry.setThemeId(frontendTokenDefinition.getThemeId());
            } else {
                styleBookEntry.setThemeId(publicLayoutSet.getThemeId());
            }
        }
        return this.publishDraft(styleBookEntry);
    }

    public StyleBookEntry copyStyleBookEntry(long userId, long groupId, long sourceStyleBookEntryId, ServiceContext serviceContext) throws PortalException {
        StyleBookEntry sourceStyleBookEntry = this.getStyleBookEntry(sourceStyleBookEntryId);
        String name = this._getUniqueCopyName(sourceStyleBookEntry);
        StyleBookEntry targetStyleBookEntry = this.addStyleBookEntry(null, userId, groupId, false, sourceStyleBookEntry.getFrontendTokensValues(), name, "", sourceStyleBookEntry.getThemeId(), serviceContext);
        long previewFileEntryId = this._copyStyleBookEntryPreviewFileEntry(userId, groupId, sourceStyleBookEntry, targetStyleBookEntry);
        StyleBookEntry draftStyleBookEntry = this.fetchDraft(sourceStyleBookEntry);
        if (draftStyleBookEntry != null) {
            StyleBookEntry copyDraftStyleBookEntry = this.getDraft(targetStyleBookEntry);
            copyDraftStyleBookEntry.setFrontendTokensValues(draftStyleBookEntry.getFrontendTokensValues());
            this.updateDraft(copyDraftStyleBookEntry);
        }
        return this.updatePreviewFileEntryId(targetStyleBookEntry.getStyleBookEntryId(), previewFileEntryId);
    }

    public void deleteStyleBookEntries(long groupId) throws PortalException {
        for (StyleBookEntry styleBookEntry : this.styleBookEntryPersistence.findByGroupId_Head(groupId, true)) {
            this.deleteStyleBookEntry(styleBookEntry);
        }
    }

    @Override
    public StyleBookEntry deleteStyleBookEntry(long styleBookEntryId) throws PortalException {
        return this.deleteStyleBookEntry(this.getStyleBookEntry(styleBookEntryId));
    }

    public StyleBookEntry deleteStyleBookEntry(String externalReferenceCode, long groupId) throws PortalException {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.fetchByERC_G_Head(externalReferenceCode, groupId, true);
        return this.deleteStyleBookEntry(styleBookEntry);
    }

    @Override
    public StyleBookEntry deleteStyleBookEntry(StyleBookEntry styleBookEntry) throws PortalException {
        if (styleBookEntry.getPreviewFileEntryId() > 0L) {
            PortletFileRepositoryUtil.deletePortletFileEntry((long)styleBookEntry.getPreviewFileEntryId());
        }
        return this.delete(styleBookEntry);
    }

    public StyleBookEntry fetchDefaultStyleBookEntry(long groupId, String themeId) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group != null && FeatureFlagManagerUtil.isEnabled((long)group.getCompanyId(), (String)"LPD-30204")) {
            return this.styleBookEntryPersistence.fetchByG_D_T_First(groupId, true, themeId, null);
        }
        return this.styleBookEntryPersistence.fetchByG_D_Head_First(groupId, true, true, null);
    }

    public StyleBookEntry fetchStyleBookEntry(long groupId, String styleBookEntryKey) {
        return this.styleBookEntryPersistence.fetchByG_SBEK_First(groupId, this._getStyleBookEntryKey(styleBookEntryKey), null);
    }

    public StyleBookEntry fetchStyleBookEntryByUuidAndGroupId(String uuid, long groupId) {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.fetchByUUID_G_Head(uuid, groupId, true);
        if (styleBookEntry != null) {
            return styleBookEntry;
        }
        return this.styleBookEntryPersistence.fetchByUUID_G_Head(uuid, groupId, false);
    }

    public String generateStyleBookEntryKey(long groupId, String name) {
        String styleBookEntryKey = this._getStyleBookEntryKey(name);
        styleBookEntryKey = StringUtil.replace((String)styleBookEntryKey, (char)' ', (char)'-');
        Object curStyleBookEntryKey = styleBookEntryKey;
        int count = 0;
        StyleBookEntry styleBookEntry;
        while ((styleBookEntry = this.fetchStyleBookEntry(groupId, (String)curStyleBookEntryKey)) != null) {
            curStyleBookEntryKey = styleBookEntryKey + "-" + count++;
        }
        return curStyleBookEntryKey;
    }

    public List<StyleBookEntry> getStyleBookEntries(long groupId, int start, int end, OrderByComparator<StyleBookEntry> orderByComparator) {
        return this.styleBookEntryPersistence.findByGroupId_Head(groupId, true, start, end, orderByComparator);
    }

    public List<StyleBookEntry> getStyleBookEntries(long groupId, String themeId) {
        return this.styleBookEntryPersistence.findByG_T_Head(groupId, themeId, true);
    }

    public List<StyleBookEntry> getStyleBookEntries(long groupId, String name, int start, int end, OrderByComparator<StyleBookEntry> orderByComparator) {
        return this.styleBookEntryPersistence.findByG_LikeN_Head(groupId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], true, start, end, orderByComparator);
    }

    public List<StyleBookEntry> getStyleBookEntriesByUuidAndCompanyId(String uuid, long companyId) {
        return this.styleBookEntryPersistence.findByUuid_C(uuid, companyId);
    }

    public int getStyleBookEntriesCount(long groupId) {
        return this.styleBookEntryPersistence.countByGroupId_Head(groupId, true);
    }

    public int getStyleBookEntriesCount(long groupId, String name) {
        return this.styleBookEntryPersistence.countByG_LikeN_Head(groupId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], true);
    }

    public StyleBookEntry updateDefaultStyleBookEntry(long styleBookEntryId, boolean defaultStyleBookEntry) throws PortalException {
        StyleBookEntry styleBookEntry = this.fetchStyleBookEntry(styleBookEntryId);
        if (styleBookEntry == null) {
            return null;
        }
        StyleBookEntry oldDefaultStyleBookEntry = null;
        oldDefaultStyleBookEntry = FeatureFlagManagerUtil.isEnabled((String)"LPD-30204") ? this.styleBookEntryPersistence.fetchByG_D_T_First(styleBookEntry.getGroupId(), true, styleBookEntry.getThemeId(), null) : this.styleBookEntryPersistence.fetchByG_D_First(styleBookEntry.getGroupId(), true, null);
        if (defaultStyleBookEntry && oldDefaultStyleBookEntry != null && oldDefaultStyleBookEntry.getStyleBookEntryId() != styleBookEntryId) {
            oldDefaultStyleBookEntry.setDefaultStyleBookEntry(false);
            StyleBookEntry oldDefaultDraftStyleBookEntry = this.fetchDraft(oldDefaultStyleBookEntry);
            if (oldDefaultDraftStyleBookEntry != null) {
                oldDefaultDraftStyleBookEntry.setDefaultStyleBookEntry(defaultStyleBookEntry);
                this.updateDraft(oldDefaultDraftStyleBookEntry);
            }
            this.styleBookEntryPersistence.update((BaseModel)oldDefaultStyleBookEntry);
        }
        styleBookEntry.setModifiedDate(new Date());
        styleBookEntry.setDefaultStyleBookEntry(defaultStyleBookEntry);
        StyleBookEntry draftStyleBookEntry = this.fetchDraft(styleBookEntry);
        if (draftStyleBookEntry != null) {
            draftStyleBookEntry.setDefaultStyleBookEntry(defaultStyleBookEntry);
            this.updateDraft(draftStyleBookEntry);
        }
        return (StyleBookEntry)this.styleBookEntryPersistence.update((BaseModel)styleBookEntry);
    }

    public StyleBookEntry updateFrontendTokensValues(long styleBookEntryId, String frontendTokensValues) throws PortalException {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.findByPrimaryKey(styleBookEntryId);
        styleBookEntry.setModifiedDate(new Date());
        styleBookEntry.setFrontendTokensValues(frontendTokensValues);
        StyleBookEntry draftStyleBookEntry = this.fetchDraft(styleBookEntry);
        if (draftStyleBookEntry != null) {
            draftStyleBookEntry.setModifiedDate(new Date());
            draftStyleBookEntry.setFrontendTokensValues(frontendTokensValues);
            this.updateDraft(draftStyleBookEntry);
        }
        return (StyleBookEntry)this.styleBookEntryPersistence.update((BaseModel)styleBookEntry);
    }

    public StyleBookEntry updateName(long styleBookEntryId, String name) throws PortalException {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.findByPrimaryKey(styleBookEntryId);
        this._validate(name);
        styleBookEntry.setModifiedDate(new Date());
        styleBookEntry.setName(name);
        StyleBookEntry draftStyleBookEntry = this.fetchDraft(styleBookEntry);
        if (draftStyleBookEntry != null) {
            draftStyleBookEntry.setModifiedDate(new Date());
            draftStyleBookEntry.setName(name);
            this.updateDraft(draftStyleBookEntry);
        }
        return (StyleBookEntry)this.styleBookEntryPersistence.update((BaseModel)styleBookEntry);
    }

    public StyleBookEntry updatePreviewFileEntryId(long styleBookEntryId, long previewFileEntryId) throws PortalException {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.findByPrimaryKey(styleBookEntryId);
        styleBookEntry.setModifiedDate(new Date());
        styleBookEntry.setPreviewFileEntryId(previewFileEntryId);
        StyleBookEntry draftStyleBookEntry = this.fetchDraft(styleBookEntry);
        if (draftStyleBookEntry != null) {
            draftStyleBookEntry.setModifiedDate(new Date());
            draftStyleBookEntry.setPreviewFileEntryId(previewFileEntryId);
            this.updateDraft(draftStyleBookEntry);
        }
        return (StyleBookEntry)this.styleBookEntryPersistence.update((BaseModel)styleBookEntry);
    }

    public StyleBookEntry updateStyleBookEntry(long userId, long styleBookEntryId, boolean defaultStylebookEntry, String frontendTokensValues, String name, String styleBookEntryKey, long previewFileEntryId) throws PortalException {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.findByPrimaryKey(styleBookEntryId);
        this._validate(name);
        styleBookEntryKey = Validator.isNull((String)styleBookEntryKey) ? this.generateStyleBookEntryKey(styleBookEntry.getGroupId(), name) : this._getStyleBookEntryKey(styleBookEntryKey);
        if (!StringUtil.equals((String)this._getStyleBookEntryKey(styleBookEntry.getStyleBookEntryKey()), (String)styleBookEntryKey)) {
            this._validateStyleBookEntryKey(styleBookEntry.getGroupId(), styleBookEntryKey);
        }
        styleBookEntry.setUserId(userId);
        styleBookEntry.setDefaultStyleBookEntry(defaultStylebookEntry);
        styleBookEntry.setFrontendTokensValues(frontendTokensValues);
        styleBookEntry.setName(name);
        styleBookEntry.setPreviewFileEntryId(previewFileEntryId);
        styleBookEntry.setStyleBookEntryKey(styleBookEntryKey);
        return (StyleBookEntry)this.styleBookEntryPersistence.update((BaseModel)styleBookEntry);
    }

    public StyleBookEntry updateStyleBookEntry(long styleBookEntryId, String frontendTokensValues, String name) throws PortalException {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.findByPrimaryKey(styleBookEntryId);
        this._validate(name);
        styleBookEntry.setModifiedDate(new Date());
        styleBookEntry.setFrontendTokensValues(frontendTokensValues);
        styleBookEntry.setName(name);
        StyleBookEntry draftStyleBookEntry = this.fetchDraft(styleBookEntry);
        if (draftStyleBookEntry != null) {
            draftStyleBookEntry.setModifiedDate(new Date());
            draftStyleBookEntry.setFrontendTokensValues(frontendTokensValues);
            draftStyleBookEntry.setName(name);
            this.updateDraft(draftStyleBookEntry);
        }
        return (StyleBookEntry)this.styleBookEntryPersistence.update((BaseModel)styleBookEntry);
    }

    private long _copyStyleBookEntryPreviewFileEntry(long userId, long groupId, StyleBookEntry sourceStyleBookEntry, StyleBookEntry copyStyleBookEntry) throws PortalException {
        if (sourceStyleBookEntry.getPreviewFileEntryId() == 0L) {
            return 0L;
        }
        FileEntry fileEntry = this._dlAppLocalService.getFileEntry(sourceStyleBookEntry.getPreviewFileEntryId());
        Repository repository = PortletFileRepositoryUtil.fetchPortletRepository((long)groupId, (String)"com_liferay_style_book_web_internal_portlet_StyleBookPortlet");
        if (repository == null) {
            ServiceContext addPortletRepositoryServiceContext = new ServiceContext();
            addPortletRepositoryServiceContext.setAddGroupPermissions(true);
            addPortletRepositoryServiceContext.setAddGuestPermissions(true);
            repository = PortletFileRepositoryUtil.addPortletRepository((long)groupId, (String)"com_liferay_style_book_web_internal_portlet_StyleBookPortlet", (ServiceContext)addPortletRepositoryServiceContext);
        }
        String fileName = copyStyleBookEntry.getStyleBookEntryId() + "_preview." + fileEntry.getExtension();
        fileEntry = PortletFileRepositoryUtil.addPortletFileEntry(null, (long)groupId, (long)userId, (String)StyleBookEntry.class.getName(), (long)copyStyleBookEntry.getStyleBookEntryId(), (String)"com_liferay_style_book_web_internal_portlet_StyleBookPortlet", (long)repository.getDlFolderId(), (InputStream)fileEntry.getContentStream(), (String)fileName, (String)fileEntry.getMimeType(), (boolean)false);
        return fileEntry.getFileEntryId();
    }

    private String _getStyleBookEntryKey(String styleBookEntryKey) {
        if (styleBookEntryKey != null) {
            styleBookEntryKey = styleBookEntryKey.trim();
            return StringUtil.toLowerCase((String)styleBookEntryKey);
        }
        return "";
    }

    private String _getUniqueCopyName(StyleBookEntry styleBookEntry) {
        StyleBookEntry existingStyleBookEntry;
        String copy = this._language.get(LocaleUtil.getSiteDefault(), "copy");
        String name = StringUtil.appendParentheticalSuffix((String)styleBookEntry.getName(), (String)copy);
        int i = 1;
        while ((existingStyleBookEntry = this.styleBookEntryPersistence.fetchByG_LikeN_First(styleBookEntry.getGroupId(), name, null)) != null) {
            name = StringUtil.appendParentheticalSuffix((String)styleBookEntry.getName(), (String)(copy + " " + i));
            ++i;
        }
        return name;
    }

    private void _validate(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new StyleBookEntryNameException("Name must not be null");
        }
        if (name.contains(".") || name.contains("/")) {
            throw new StyleBookEntryNameException("Name contains invalid characters");
        }
        int nameMaxLength = ModelHintsUtil.getMaxLength((String)StyleBookEntry.class.getName(), (String)"name");
        if (name.length() > nameMaxLength) {
            throw new StyleBookEntryNameException("Maximum length of name exceeded");
        }
    }

    private void _validateStyleBookEntryKey(long groupId, String styleBookEntryKey) throws PortalException {
        StyleBookEntry styleBookEntry = this.fetchStyleBookEntry(groupId, styleBookEntryKey = this._getStyleBookEntryKey(styleBookEntryKey));
        if (styleBookEntry != null) {
            throw new DuplicateStyleBookEntryKeyException();
        }
    }
}

