/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.style.book.item.selector.web.internal.frontend.taglib.clay.servlet.taglib;

import com.liferay.frontend.taglib.clay.servlet.taglib.VerticalCard;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.style.book.model.StyleBookEntry;
import com.liferay.style.book.util.DefaultStyleBookEntryUtil;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;

public class SelectStylebookLayoutVerticalCard
implements VerticalCard {
    private StyleBookEntry _defaultStyleBookEntry;
    private final RenderRequest _renderRequest;
    private final Layout _selLayout;
    private final StyleBookEntry _styleBookEntry;
    private final ThemeDisplay _themeDisplay;

    public SelectStylebookLayoutVerticalCard(RenderRequest renderRequest, Layout selLayout, StyleBookEntry styleBookEntry) {
        this._renderRequest = renderRequest;
        this._selLayout = selLayout;
        this._styleBookEntry = styleBookEntry;
        this._themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public String getCssClass() {
        Object cssClass = "select-style-book-option card-interactive card-interactive-secondary";
        if (this._isSelected()) {
            cssClass = (String)cssClass + " active";
        }
        return cssClass;
    }

    public StyleBookEntry getDefaultStyleBookEntry() {
        if (this._defaultStyleBookEntry != null) {
            return this._defaultStyleBookEntry;
        }
        this._defaultStyleBookEntry = DefaultStyleBookEntryUtil.getDefaultMasterStyleBookEntry((Layout)this._selLayout);
        return this._defaultStyleBookEntry;
    }

    public Map<String, String> getDynamicAttributes() {
        return HashMapBuilder.put((Object)"role", (Object)"button").put((Object)"tabIndex", (Object)"0").build();
    }

    public String getIcon() {
        return "magic";
    }

    public String getImageSrc() {
        return this._styleBookEntry.getImagePreviewURL(this._themeDisplay);
    }

    public String getStickerCssClass() {
        return "sticker-primary";
    }

    public String getStickerIcon() {
        if (this._styleBookEntry.isDefaultStyleBookEntry()) {
            return "check-circle";
        }
        return null;
    }

    public String getSubtitle() {
        StyleBookEntry defaultStyleBookEntry = this.getDefaultStyleBookEntry();
        if (this._styleBookEntry.getStyleBookEntryId() <= 0L && defaultStyleBookEntry != null) {
            return defaultStyleBookEntry.getName();
        }
        return "-";
    }

    public String getTitle() {
        return DefaultStyleBookEntryUtil.getStyleBookEntryName((Layout)this._selLayout, (Locale)this._themeDisplay.getLocale(), (StyleBookEntry)this._styleBookEntry);
    }

    public boolean isSelectable() {
        return false;
    }

    private boolean _isSelected() {
        long styleBookEntryId = ParamUtil.getLong((PortletRequest)this._renderRequest, (String)"styleBookEntryId");
        return Objects.equals(styleBookEntryId, this._styleBookEntry.getStyleBookEntryId());
    }
}

