/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.regex.Pattern;

@StatelessCheck
public final class AbstractClassNameCheck
extends AbstractCheck {
    public static final String MSG_ILLEGAL_ABSTRACT_CLASS_NAME = "illegal.abstract.class.name";
    public static final String MSG_NO_ABSTRACT_CLASS_MODIFIER = "no.abstract.class.modifier";
    private boolean ignoreModifier;
    private boolean ignoreName;
    private Pattern format = Pattern.compile("^Abstract.+$");

    public void setIgnoreModifier(boolean value) {
        this.ignoreModifier = value;
    }

    public void setIgnoreName(boolean value) {
        this.ignoreName = value;
    }

    public void setFormat(Pattern pattern) {
        this.format = pattern;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{14};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        this.visitClassDef(ast);
    }

    private void visitClassDef(DetailAST ast) {
        String className = ast.findFirstToken(58).getText();
        if (AbstractClassNameCheck.isAbstract(ast)) {
            if (!this.ignoreName && !this.isMatchingClassName(className)) {
                this.log(ast, MSG_ILLEGAL_ABSTRACT_CLASS_NAME, className, this.format.pattern());
            }
        } else if (!this.ignoreModifier && this.isMatchingClassName(className)) {
            this.log(ast, MSG_NO_ABSTRACT_CLASS_MODIFIER, className);
        }
    }

    private static boolean isAbstract(DetailAST ast) {
        DetailAST abstractAST = ast.findFirstToken(5).findFirstToken(40);
        return abstractAST != null;
    }

    private boolean isMatchingClassName(String className) {
        return this.format.matcher(className).find();
    }
}

