/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.List;

public class JSONBatchEngineDataFileCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws JSONException {
        if (!absolutePath.endsWith(".batch-engine-data.json")) {
            return content;
        }
        JSONObject jsonObject = new JSONObjectImpl(content);
        jsonObject.remove("actions");
        jsonObject.remove("facets");
        jsonObject = this._checkConfiguration(jsonObject);
        jsonObject = this._checkItems(jsonObject);
        return JSONUtil.toString(jsonObject);
    }

    private JSONObject _checkConfiguration(JSONObject jsonObject) {
        JSONObject configurationJSONObject = jsonObject.getJSONObject("configuration");
        if (configurationJSONObject == null) {
            return jsonObject;
        }
        configurationJSONObject.remove("companyId");
        boolean multiCompany = configurationJSONObject.getBoolean("multiCompany");
        if (!multiCompany) {
            configurationJSONObject.remove("multiCompany");
        }
        configurationJSONObject.remove("userId");
        configurationJSONObject.remove("version");
        jsonObject.put("configuration", configurationJSONObject);
        return jsonObject;
    }

    private JSONObject _checkItems(JSONObject jsonObject) {
        JSONArray jsonArray = jsonObject.getJSONArray("items");
        if (jsonArray == null) {
            return jsonObject;
        }
        List<Object> objects = JSONUtil.toObjectList(jsonArray);
        jsonArray = new JSONArrayImpl();
        for (Object object : objects) {
            JSONObject itemJSONObject = (JSONObject)object;
            String defaultLanguageId = itemJSONObject.getString("defaultLanguageId");
            if (defaultLanguageId.equals("en_US")) {
                itemJSONObject.remove("defaultLanguageId");
            }
            jsonArray.put(itemJSONObject);
        }
        jsonObject.put("items", jsonArray);
        return jsonObject;
    }
}

