/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseJakartaTransformCheck;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDJakartaTransformCheck
extends BaseJakartaTransformCheck {
    private static final Pattern _osgiContractPattern = Pattern.compile("\\(osgi\\.contract!?=(\\w+)\\)\\(version[<>]?=([\\d.]+)\\)");
    private Map<String, String> _jakartaTransformOSGiContractsMap;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        content = this._formatHeaders(content);
        content = this.replace(content);
        return this.replaceTaglibURIs(content);
    }

    private String _formatHeaders(String content) throws IOException {
        Properties properties = new Properties();
        properties.load(new StringReader(content));
        this._replaceProvideCapability(properties);
        return this._toString(properties);
    }

    private String _formatParameters(Parameters parameters, String propertyName) {
        StringBundler sb = new StringBundler();
        for (Map.Entry entry : parameters.entrySet()) {
            String parameterKey = (String)entry.getKey();
            sb.append("\t");
            sb.append(parameterKey.replaceAll("(.+?)~+", "$1"));
            String attrsString = String.valueOf(entry.getValue());
            if (attrsString.isBlank()) {
                sb.append(",\\\n");
                continue;
            }
            if (!propertyName.equals("Provide-Capability") && !propertyName.equals("Require-Capability")) {
                sb.append(";");
                sb.append(attrsString);
                sb.append(",\\\n");
                continue;
            }
            attrsString = "\t\t" + attrsString;
            int x = -1;
            while ((x = attrsString.indexOf(";", x + 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(attrsString, x)) continue;
                attrsString = StringUtil.replaceFirst(attrsString, ";", ";\\\n\t\t", x);
            }
            sb.append(";\\\n");
            sb.append(attrsString);
            sb.append(",\\\n");
        }
        if (sb.length() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private synchronized Map<String, String> _getJakartaTransformOSGiContractsMap() throws IOException {
        String[] lines;
        if (this._jakartaTransformOSGiContractsMap != null) {
            return this._jakartaTransformOSGiContractsMap;
        }
        this._jakartaTransformOSGiContractsMap = new HashMap<String, String>();
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("dependencies/jakarta-transform-osgi-contracts.txt");
        if (inputStream == null) {
            return Collections.emptyMap();
        }
        for (String line : lines = StringUtil.splitLines(StringUtil.read(inputStream))) {
            String[] parts = line.split("=");
            this._jakartaTransformOSGiContractsMap.put(parts[0], parts[1]);
        }
        return this._jakartaTransformOSGiContractsMap;
    }

    private void _replaceProvideCapability(Properties properties) throws IOException {
        String provideCapability = properties.getProperty("Provide-Capability");
        if (provideCapability == null) {
            return;
        }
        Map<String, String> jakartaTransformOSGiContractsMap = this._getJakartaTransformOSGiContractsMap();
        Parameters parameters = new Parameters(provideCapability);
        for (Map.Entry entry : parameters.entrySet()) {
            String newContract;
            Matcher matcher;
            String parameterKey = (String)entry.getKey();
            if (!parameterKey.matches("osgi\\.contract~*")) continue;
            Attrs attrs = (Attrs)entry.getValue();
            String osgiContract = attrs.get("osgi.contract");
            if (osgiContract != null) {
                String newContract2 = jakartaTransformOSGiContractsMap.get(osgiContract);
                if (newContract2 == null) continue;
                String[] values = newContract2.split(":");
                attrs.put("osgi.contract", values[0]);
                String version = attrs.get("version");
                if (version == null) continue;
                attrs.put("version", values[1]);
                continue;
            }
            String filter = attrs.get("filter:");
            if (filter == null || !(matcher = _osgiContractPattern.matcher(filter)).find() || (newContract = jakartaTransformOSGiContractsMap.get(osgiContract = matcher.group(1))) == null) continue;
            String[] values = newContract.split(":");
            filter = StringUtil.replaceFirst(filter, osgiContract, values[0], matcher.start(1));
            filter = StringUtil.replaceFirst(filter, matcher.group(2), values[1], matcher.start(2));
            attrs.put("filter:", filter);
        }
        properties.setProperty("Provide-Capability", parameters.toString());
    }

    private String _toString(Properties properties) {
        ArrayList<String> propertyNames = new ArrayList<String>(properties.stringPropertyNames());
        Collections.sort(propertyNames, new HeaderComparator());
        StringBundler sb = new StringBundler(propertyNames.size() * 4);
        for (String propertyName : propertyNames) {
            sb.append(propertyName);
            Parameters parameters = new Parameters(properties.getProperty(propertyName));
            String parametersString = this._formatParameters(parameters, propertyName);
            if (!parametersString.contains("\n")) {
                parametersString = parametersString.trim();
                sb.append(": ");
            } else {
                sb.append(":\\\n");
            }
            sb.append(parametersString);
            sb.append("\n");
        }
        if (sb.length() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private static class HeaderComparator
    implements Comparator<String> {
        private HeaderComparator() {
        }

        @Override
        public int compare(String header1, String header2) {
            if (header1.startsWith("-") ^ header2.startsWith("-")) {
                return -header1.compareTo(header2);
            }
            String headerName1 = StringUtil.extractFirst(header1, ":");
            String headerName2 = StringUtil.extractFirst(header2, ":");
            if (headerName1 != null && headerName2 != null) {
                return headerName1.compareTo(headerName2);
            }
            return header1.compareTo(header2);
        }
    }
}

