/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseJakartaTransformCheck;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleJakartaTransformCheck
extends BaseJakartaTransformCheck {
    private static final Pattern _dependencyPattern = Pattern.compile("\t\\w+(?:\\s|\\()+group:\\s*['\"](.+)['\"],\\s*name:\\s*['\"](.+)['\"],\\s*(?:transitive:\\s*\\w+,\\s*)?version:\\s*['\"](.+)['\"]");
    private Map<String, String> _jakartaTransformDependenciesMap;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        Map<String, String> jakartaTransformDependenciesMap = this._getJakartaTransformDependenciesMap();
        StringBuffer sb = new StringBuffer();
        Matcher matcher = _dependencyPattern.matcher(content);
        while (matcher.find()) {
            String jakartaTransformDependencies = jakartaTransformDependenciesMap.get(matcher.group(1) + ":" + matcher.group(2));
            if (jakartaTransformDependencies == null) continue;
            String[] dependencies = StringUtil.split(jakartaTransformDependencies, "|");
            StringBuilder dependencySB = new StringBuilder(dependencies.length * 8);
            for (int i = 0; i < dependencies.length; ++i) {
                String[] parts = StringUtil.split(dependencies[i], ":");
                dependencySB.append(content.substring(matcher.start(0), matcher.start(1)));
                dependencySB.append(parts[0]);
                dependencySB.append(content.substring(matcher.end(1), matcher.start(2)));
                dependencySB.append(parts[1]);
                dependencySB.append(content.substring(matcher.end(2), matcher.start(3)));
                dependencySB.append(parts[2]);
                dependencySB.append(content.substring(matcher.end(3), matcher.end(0)));
                if (i >= dependencies.length - 1) continue;
                dependencySB.append('\n');
            }
            String dependency = dependencySB.toString();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(dependency));
        }
        matcher.appendTail(sb);
        return this.replace(sb.toString());
    }

    private synchronized Map<String, String> _getJakartaTransformDependenciesMap() throws IOException {
        String[] lines;
        if (this._jakartaTransformDependenciesMap != null) {
            return this._jakartaTransformDependenciesMap;
        }
        this._jakartaTransformDependenciesMap = new HashMap<String, String>();
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("dependencies/jakarta-transform-dependencies.txt");
        if (inputStream == null) {
            return Collections.emptyMap();
        }
        for (String line : lines = StringUtil.splitLines(StringUtil.read(inputStream))) {
            String[] parts = line.split("=");
            this._jakartaTransformDependenciesMap.put(parts[0], parts[1]);
        }
        return this._jakartaTransformDependenciesMap;
    }
}

