/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiAntCommandParametersOrderCheck
extends BaseFileCheck {
    private static final Pattern _antCommandCallPattern = Pattern.compile("\n\t+AntCommand\\((.*?)\\);\n", 32);
    private static final Pattern _parameterPattern = Pattern.compile(" -D[^=]+?=(\\\\\"|).+?\\1(?= |\\Z)");
    private static final Pattern _valuePattern = Pattern.compile("\t+value1 = \"(.+)\"\\);\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        int compare;
        String parameter;
        String previousParameter;
        ParameterNameComparator parameterNameComparator = new ParameterNameComparator();
        Matcher matcher1 = _antCommandCallPattern.matcher(content);
        while (matcher1.find()) {
            String antCommandCall = matcher1.group();
            if (this.getLevel(antCommandCall) != 0) continue;
            Matcher matcher2 = _valuePattern.matcher(antCommandCall);
            while (matcher2.find()) {
                Matcher matcher3 = _parameterPattern.matcher(matcher2.group(1));
                previousParameter = null;
                while (matcher3.find()) {
                    parameter = matcher3.group();
                    if (previousParameter != null && (compare = parameterNameComparator.compare(previousParameter, parameter)) > 0) {
                        content = StringUtil.replaceFirst(content, parameter, previousParameter, matcher1.start());
                        return StringUtil.replaceFirst(content, previousParameter, parameter, matcher1.start());
                    }
                    previousParameter = parameter;
                }
            }
        }
        int x = -1;
        while ((x = content.indexOf("AntCommands.runCommand(", x + 1)) != -1) {
            List<String> parameterList = JavaSourceUtil.getParameterList(JavaSourceUtil.getMethodCall(content, x));
            if (parameterList.size() != 2) continue;
            Matcher matcher = _parameterPattern.matcher(StringUtil.unquote(parameterList.get(1)));
            previousParameter = null;
            while (matcher.find()) {
                parameter = matcher.group();
                if (previousParameter != null && (compare = parameterNameComparator.compare(previousParameter, parameter)) > 0) {
                    content = StringUtil.replaceFirst(content, parameter, previousParameter, x);
                    return StringUtil.replaceFirst(content, previousParameter, parameter, x);
                }
                previousParameter = parameter;
            }
        }
        return content;
    }

    private class ParameterNameComparator
    extends NaturalOrderStringComparator {
        private ParameterNameComparator() {
        }

        @Override
        public int compare(String parameter1, String parameter2) {
            return super.compare(this._getParameterName(parameter1), this._getParameterName(parameter2));
        }

        private String _getParameterName(String parameter) {
            int x = parameter.indexOf("=");
            return parameter.substring(0, x);
        }
    }
}

