/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.PythonSourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PythonClassesAndMethodsOrderCheck
extends BaseFileCheck {
    private static final String _MAX_LINE_LENGTH = "maxLineLength";
    private static final Pattern _classDefinitionHeaderPattern1 = Pattern.compile("(?<=\n)(\t*)class (\\w+)(\\((.*?)\\))?:\n+", 32);
    private static final Pattern _classDefinitionHeaderPattern2 = Pattern.compile("class (\\w+)(\\((.*?)\\))?:", 32);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this._formatClassDefinitionHeader(absolutePath, content);
        return this._sortItems(fileName, content, "");
    }

    private List<String> _combineAnnotationsAndComments(List<String> statements, String indent) {
        ArrayList<String> statementsList = new ArrayList<String>();
        StringBundler sb = new StringBundler();
        String previousStatement = "";
        for (String statement : statements) {
            if (statement.startsWith(indent + "@") || statement.startsWith(indent + "#")) {
                sb.append(statement);
                sb.append("\n");
            } else if (previousStatement.startsWith(indent + "@") || previousStatement.startsWith(indent + "#")) {
                sb.append(statement);
                statementsList.add(sb.toString());
                sb.setIndex(0);
            } else {
                statementsList.add(statement);
            }
            previousStatement = statement;
        }
        if (sb.index() > 0) {
            statementsList.add(StringUtil.trimTrailing(sb.toString()));
        }
        return statementsList;
    }

    private String _formatClassDefinitionHeader(String absolutePath, String content) {
        int maxLineLength = 0;
        try {
            maxLineLength = Integer.parseInt(this.getAttributeValue(_MAX_LINE_LENGTH, absolutePath));
        }
        catch (NumberFormatException numberFormatException) {
            return content;
        }
        Matcher matcher = _classDefinitionHeaderPattern1.matcher(content);
        while (matcher.find()) {
            String indent = matcher.group(1);
            String className = matcher.group(2);
            List<String> parentClassList = ListUtil.fromString(matcher.group(4), ",");
            for (int i = 0; i < parentClassList.size(); ++i) {
                parentClassList.set(i, StringUtil.trim(parentClassList.get(i)));
            }
            StringBundler sb = new StringBundler(7);
            sb.append(indent);
            sb.append("class ");
            sb.append(className);
            if (ListUtil.isNotEmpty(parentClassList)) {
                sb.append("(");
                sb.append(ListUtil.toString(parentClassList, "", ", "));
                sb.append(")");
            }
            sb.append(":");
            content = StringUtil.replace(content, matcher.group(), this._splitLine(sb.toString(), indent + "\t", maxLineLength) + "\n\n");
        }
        return content;
    }

    private int _sortClasses(String class1, String class2) {
        Matcher matcher = _classDefinitionHeaderPattern2.matcher(class1);
        if (!matcher.find()) {
            return 0;
        }
        String className1 = matcher.group(1);
        List<String> parentClassList = ListUtil.fromString(matcher.group(3), ",");
        for (int i = 0; i < parentClassList.size(); ++i) {
            parentClassList.set(i, StringUtil.trim(parentClassList.get(i)));
        }
        matcher = _classDefinitionHeaderPattern2.matcher(class2);
        if (!matcher.find()) {
            return 0;
        }
        String className2 = matcher.group(1);
        if (className1.compareTo(className2) < 0) {
            if (!parentClassList.contains(className2)) {
                return -1;
            }
            return 1;
        }
        return className1.compareTo(className2);
    }

    private int _sortItems(String statement1, String statement2) {
        String trimmedStatement1 = StringUtil.trimLeading(statement1.replaceAll("(\t*[#@].*(\\Z|\n))*(.*)", "$3"));
        String trimmedStatement2 = StringUtil.trimLeading(statement2.replaceAll("(\t*[#@].*(\\Z|\n))*(.*)", "$3"));
        if (Validator.isNull(trimmedStatement1) || Validator.isNull(trimmedStatement2)) {
            return 0;
        }
        if (trimmedStatement1.startsWith("class ") && trimmedStatement2.startsWith("class ")) {
            return this._sortClasses(trimmedStatement1, trimmedStatement2);
        }
        if (trimmedStatement1.startsWith("def ") && trimmedStatement2.startsWith("def ")) {
            return this._sortMethods(trimmedStatement1, trimmedStatement2);
        }
        return 0;
    }

    private String _sortItems(String fileName, String content, String indent) {
        List<String> statements = PythonSourceUtil.getPythonStatements(content, indent);
        statements = this._combineAnnotationsAndComments(statements, indent);
        ArrayList<String> oldStatements = new ArrayList<String>(statements);
        Collections.sort(statements, new Comparator<String>(){

            @Override
            public int compare(String statement1, String statement2) {
                return PythonClassesAndMethodsOrderCheck.this._sortItems(statement1, statement2);
            }
        });
        if (!oldStatements.equals(statements)) {
            StringBundler sb = new StringBundler(statements.size() * 2);
            for (String statement : statements) {
                sb.append(statement);
                sb.append("\n");
            }
            sb.setIndex(sb.index() - 1);
            String[] lines = content.split("\n");
            content = !indent.equals("") ? lines[0] + "\n" + sb.toString() : sb.toString();
        }
        statements = PythonSourceUtil.getPythonStatements(content, indent);
        for (String statement : statements) {
            String nestedStatementIndent = PythonSourceUtil.getNestedStatementIndent(statement);
            if (nestedStatementIndent.equals("")) continue;
            content = StringUtil.replaceFirst(content, statement, this._sortItems(fileName, statement, nestedStatementIndent));
        }
        return content;
    }

    private int _sortMethods(String method1, String method2) {
        String[] lines1 = method1.split("\n", 2);
        String methodName1 = lines1[0].replaceFirst("def (\\w+).*", "$1");
        String[] lines2 = method2.split("\n", 2);
        String methodName2 = lines2[0].replaceFirst("def (\\w+).*", "$1");
        return methodName1.compareTo(methodName2);
    }

    private String _splitLine(String line, String indent, int maxLineLength) {
        if (line.length() <= maxLineLength) {
            return line;
        }
        int pos = line.indexOf(", ", indent.length());
        if (pos == -1) {
            return line;
        }
        if (pos > maxLineLength) {
            return StringBundler.concat(line.substring(0, pos + 1), "\n", this._splitLine(indent + StringUtil.trimLeading(line.substring(pos + 2)), indent, maxLineLength));
        }
        pos = line.lastIndexOf(", ", maxLineLength);
        return StringBundler.concat(line.substring(0, pos + 1), "\n", this._splitLine(indent + StringUtil.trimLeading(line.substring(pos + 2)), indent, maxLineLength));
    }
}

