/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.processor.SourceProcessor;
import java.io.File;

public class JavaUpgradeMissingTestCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!this.isModulesFile(absolutePath) && !this.isPortalSource()) {
            return content;
        }
        String className = JavaSourceUtil.getClassName(fileName);
        if (!absolutePath.contains("/upgrade/") || absolutePath.contains("-test/") || className.startsWith("Base") || !this.isUpgradeProcess(absolutePath, content)) {
            return content;
        }
        SourceProcessor sourceProcessor = this.getSourceProcessor();
        SourceFormatterArgs sourceFormatterArgs = sourceProcessor.getSourceFormatterArgs();
        for (String currentBranchRenamedFileName : sourceFormatterArgs.getCurrentBranchRenamedFileNames()) {
            if (!absolutePath.endsWith(currentBranchRenamedFileName)) continue;
            return content;
        }
        for (String currentBranchAddedFileNames : sourceFormatterArgs.getCurrentBranchAddedFileNames()) {
            if (!absolutePath.endsWith(currentBranchAddedFileNames)) continue;
            this._checkMissingTestFile(fileName, absolutePath, content, className);
            return content;
        }
        return content;
    }

    private void _checkMissingTestFile(String fileName, String absolutePath, String content, String className) {
        String expectedTestClassName = StringBundler.concat(JavaSourceUtil.getPackageName(content), ".test.", className, "Test");
        expectedTestClassName = StringUtil.replace(expectedTestClassName, "kernel.upgrade.data.cleanup.test", "upgrade.data.cleanup.test");
        File file = JavaSourceUtil.getJavaFile(expectedTestClassName = StringUtil.replace(expectedTestClassName, "kernel.upgrade.test", "upgrade.test"), SourceUtil.getRootDirName(absolutePath), this.getBundleSymbolicNamesMap(absolutePath));
        if (file == null || !file.exists()) {
            this.addMessage(fileName, "Test class \"" + expectedTestClassName + "\" does not exist");
        }
    }
}

