/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPXSSVulnerabilitiesCheck
extends BaseFileCheck {
    private static final Pattern _xssPattern = Pattern.compile("\\s+([^\\s]+)\\s*=\\s*(Bean)?ParamUtil\\.getString\\(");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._fixXSSVulnerability(content);
    }

    private String _fixXSSVulnerability(String content) {
        Matcher matcher1 = _xssPattern.matcher(content);
        String jspVariable = null;
        int vulnerabilityPos = -1;
        while (matcher1.find()) {
            jspVariable = matcher1.group(1);
            String anchorVulnerability = " href=\"<%= " + jspVariable + " %>";
            String inputVulnerability = " value=\"<%= " + jspVariable + " %>";
            vulnerabilityPos = Math.max(this._getTaglibXSSVulnerabilityPos(content, anchorVulnerability), this._getTaglibXSSVulnerabilityPos(content, inputVulnerability));
            if (vulnerabilityPos != -1) break;
            Pattern pattern = Pattern.compile("('|\\(\"| \"|\\.)<%= " + jspVariable + " %>");
            Matcher matcher2 = pattern.matcher(content);
            if (!matcher2.find()) continue;
            vulnerabilityPos = matcher2.start();
            break;
        }
        if (vulnerabilityPos != -1) {
            return StringUtil.replaceFirst(content, "<%= " + jspVariable + " %>", "<%= HtmlUtil.escape(" + jspVariable + ") %>", vulnerabilityPos);
        }
        return content;
    }

    private int _getTaglibXSSVulnerabilityPos(String content, String vulnerability) {
        String tagContent;
        int x = -1;
        do {
            if ((x = content.indexOf(vulnerability, x + 1)) == -1) {
                return x;
            }
            tagContent = null;
            int y = x;
            do {
                if ((y = content.lastIndexOf(60, y - 1)) != -1) continue;
                return -1;
            } while (content.charAt(y + 1) == '%' || this.getLevel(tagContent = content.substring(y, x), "<", ">") != 1);
        } while (tagContent.startsWith("<aui:") || tagContent.startsWith("<liferay-portlet:") || tagContent.startsWith("<liferay-util:") || tagContent.startsWith("<portlet:"));
        return x;
    }
}

