/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class ClassNameIdCheck
extends BaseCheck {
    private static final String _MSG_AVOID_VARIABLE_NAME = "variable.name.avoid";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        String absolutePath = this.getAbsolutePath();
        if (absolutePath.contains("/test/") || absolutePath.contains("/testIntegration/")) {
            return;
        }
        String className = JavaSourceUtil.getClassName(absolutePath);
        if (className.equals("ClassNameLocalServiceImpl") || className.equals("StagedModelType") || className.endsWith("Criterion") || className.endsWith("DisplayContext") || className.endsWith("ModelImpl") || className.endsWith("Tag")) {
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null) {
            return;
        }
        List<DetailAST> variableDefDetailASTList = this.getAllChildTokens(detailAST.findFirstToken(6), false, 10);
        for (DetailAST variableDefDetailAST : variableDefDetailASTList) {
            List<DetailAST> variableCallerDetailASTList;
            String variableName;
            if (!StringUtil.equalsIgnoreCase(this.getTypeName(variableDefDetailAST, false, false, false), "long") || !(variableName = this.getName(variableDefDetailAST)).contains("ClassNameId") && !variableName.contains("classNameId") || this._isAssignedInsideConstructor(variableCallerDetailASTList = this.getVariableCallerDetailASTList(variableDefDetailAST)) || this._isInsideGetterAndSetter(variableCallerDetailASTList, variableName)) continue;
            this.log(variableDefDetailAST, _MSG_AVOID_VARIABLE_NAME, new Object[]{variableName});
        }
    }

    private boolean _isAssignedInsideConstructor(List<DetailAST> variableCallerDetailASTList) {
        for (DetailAST variableCallerDetailAST : variableCallerDetailASTList) {
            if (!this.hasParentWithTokenType(variableCallerDetailAST, 8)) continue;
            return true;
        }
        return false;
    }

    private boolean _isInsideGetterAndSetter(List<DetailAST> variableCallerDetailASTList, String variableName) {
        String trimmedVariableName = variableName;
        if (variableName.startsWith("_")) {
            trimmedVariableName = variableName.substring(1);
        }
        for (DetailAST variableCallerDetailAST : variableCallerDetailASTList) {
            String methodName;
            DetailAST methodDefDetailAST = this.getParentWithTokenType(variableCallerDetailAST, 9);
            if (methodDefDetailAST == null || (methodName = this.getName(methodDefDetailAST)).matches("(?i)_?(get|set)" + trimmedVariableName)) continue;
            return false;
        }
        return true;
    }
}

