/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class NestedFieldAnnotationCheck
extends BaseCheck {
    private static final String _MSG_NESTED_FIELD_SUPPORT_MISSING = "nested.field.support.missing";
    private static final String _MSG_NESTED_FIELD_SUPPORT_UNNEEDED = "nested.field.support.unneeded";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (detailAST.getParent() != null || !AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Component")) {
            return;
        }
        String className = this.getName(detailAST);
        if (!className.endsWith("ResourceImpl")) {
            return;
        }
        DetailAST annotationDetailAST = AnnotationUtil.getAnnotation((DetailAST)detailAST, (String)"Component");
        String nestedFieldSupportValue = this._getNestedFieldSupportValue(annotationDetailAST);
        boolean hasNestedFieldAnnotation = this._hasNestedFieldAnnotation(this.getAllChildTokens(detailAST, true, 9));
        if (hasNestedFieldAnnotation && !Objects.equals(nestedFieldSupportValue, "true")) {
            this.log(annotationDetailAST, _MSG_NESTED_FIELD_SUPPORT_MISSING, new Object[0]);
        } else if (!hasNestedFieldAnnotation && nestedFieldSupportValue != null) {
            this.log(annotationDetailAST, _MSG_NESTED_FIELD_SUPPORT_UNNEEDED, new Object[0]);
        }
    }

    private String _getNestedFieldSupportValue(DetailAST annotationDetailAST) {
        if (annotationDetailAST == null) {
            return null;
        }
        DetailAST annotationMemberValuePairDetailAST = this.getAnnotationMemberValuePairDetailAST(annotationDetailAST, "property");
        if (annotationMemberValuePairDetailAST == null) {
            return null;
        }
        ArrayList<DetailAST> expressionDetailASTList = new ArrayList<DetailAST>();
        DetailAST annotationArrayInitDetailAST = annotationMemberValuePairDetailAST.findFirstToken(162);
        if (annotationArrayInitDetailAST != null) {
            expressionDetailASTList.addAll(this.getAllChildTokens(annotationArrayInitDetailAST, false, 28));
        } else {
            expressionDetailASTList.add(annotationMemberValuePairDetailAST.findFirstToken(28));
        }
        for (DetailAST expressionDetailAST : expressionDetailASTList) {
            String[] property;
            DetailAST firstChildDetailAST = expressionDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() != 139 || !(property = StringUtil.split(StringUtil.unquote(firstChildDetailAST.getText()), '='))[0].equals("nested.field.support")) continue;
            return property[1];
        }
        return null;
    }

    private boolean _hasNestedFieldAnnotation(List<DetailAST> detailASTList) {
        for (DetailAST detailAST : detailASTList) {
            DetailAST annotationDetailAST = AnnotationUtil.getAnnotation((DetailAST)detailAST, (String)"NestedField");
            if (annotationDetailAST == null) continue;
            return true;
        }
        return false;
    }
}

