/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check.util;

import com.liferay.portal.kernel.util.StringUtil;
import java.util.Stack;

public class VelocityMigrationUtil {
    public static boolean isVelocityStatement(String line, String statement) {
        int previousCharIndex = line.indexOf(statement) - 1;
        return line.indexOf(statement) == 0 || line.charAt(previousCharIndex) != '<' && line.charAt(previousCharIndex) != '/';
    }

    public static String removeFirstParenthesis(String line) {
        char previousChar = line.charAt(line.indexOf(40) - 1);
        if (previousChar != ' ') {
            return StringUtil.replaceFirst(line, '(', ' ');
        }
        return StringUtil.removeFirst(line, "(");
    }

    public static void replaceStatementEnd(int lineIndex, String[] lines, String statement) {
        Stack<String> stack = new Stack<String>();
        stack.push(statement);
        int nextLineIndex = lineIndex;
        while (!stack.empty()) {
            String nextLine;
            if ((nextLine = lines[++nextLineIndex]).contains("#if") && VelocityMigrationUtil.isVelocityStatement(nextLine, "#if")) {
                stack.push("#if");
            }
            if (nextLine.contains("#foreach")) {
                stack.push("#foreach");
            }
            if (nextLine.contains("#macro") && VelocityMigrationUtil.isVelocityStatement(nextLine, "#macro")) {
                stack.push("#macro");
            }
            if (nextLine.contains("#end")) {
                stack.pop();
            }
            if (!stack.empty()) continue;
            if (statement.equals("#if")) {
                lines[nextLineIndex] = StringUtil.replace(nextLine, "#end", "</#if>");
            } else if (statement.equals("#foreach")) {
                lines[nextLineIndex] = StringUtil.replace(nextLine, "#end", "</#list>");
            }
            if (!statement.equals("#macro")) continue;
            lines[nextLineIndex] = StringUtil.replace(nextLine, "#end", "</#macro>");
        }
    }
}

