/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.elements.CommandPoshiElement;
import com.liferay.poshi.core.elements.DefinitionPoshiElement;
import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.elements.PoshiNode;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import com.liferay.poshi.core.util.Validator;
import org.dom4j.Attribute;
import org.dom4j.tree.DefaultAttribute;

public class PoshiElementAttribute
extends DefaultAttribute
implements PoshiNode<Attribute, PoshiElementAttribute> {
    private String _poshiScript;

    public PoshiElementAttribute(Attribute attribute) {
        super(attribute.getParent(), attribute.getName(), attribute.getValue(), attribute.getNamespace());
    }

    public PoshiElementAttribute(String name, String value, String poshiScript) {
        super(name, value);
        this.setPoshiScript(poshiScript);
    }

    @Override
    public PoshiElementAttribute clone(Attribute attribute) {
        return null;
    }

    @Override
    public PoshiElementAttribute clone(String poshiScript) throws PoshiScriptParserException {
        return null;
    }

    @Override
    public String getPoshiScript() {
        return this._poshiScript;
    }

    @Override
    public void parsePoshiScript(String poshiScript) throws PoshiScriptParserException {
    }

    @Override
    public void setPoshiScript(String poshiScript) {
        this._poshiScript = poshiScript;
    }

    @Override
    public String toPoshiScript() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        String value = this.getValue();
        PoshiElement parentPoshiElement = (PoshiElement)this.getParent();
        if ((parentPoshiElement instanceof CommandPoshiElement || parentPoshiElement instanceof DefinitionPoshiElement) && value.equals("")) {
            return sb.toString();
        }
        sb.append(" = ");
        value = value.replace("\"", "\\\"");
        if (parentPoshiElement.isQuotedContent(value)) {
            value = "\"" + value + "\"";
        }
        sb.append(value);
        return sb.toString();
    }

    @Override
    public void validatePoshiScript() throws PoshiScriptParserException {
        if (Validator.isNull(this.getPoshiScript())) {
            return;
        }
        String originalPoshiScript = this.getPoshiScript();
        originalPoshiScript = originalPoshiScript.replaceAll("\\s+", "");
        String generatedPoshiScript = this.toPoshiScript();
        if (!originalPoshiScript.equals(generatedPoshiScript = generatedPoshiScript.replaceAll("\\s+", ""))) {
            originalPoshiScript = originalPoshiScript.replaceFirst("\"", "");
            if (!(originalPoshiScript = originalPoshiScript.substring(0, originalPoshiScript.length() - 1)).equals(generatedPoshiScript)) {
                throw new PoshiScriptParserException("Poshi Script syntax is not preserved in translation", this);
            }
        }
    }
}

