/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.parser;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.parser.GradleFile;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleFileParser {
    private static final Pattern _importsPattern = Pattern.compile("(^[ \t]*import\\s+.*\n+)+", 8);
    private static final Pattern _taskPattern = Pattern.compile(".*^task\\s+.*$.*", 40);

    public static GradleFile parse(String fileName, String content) {
        TreeSet<String> applyPlugins = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        String bodyBlock = "";
        String buildScriptBlock = "";
        String extScriptBlock = "";
        String importsBlock = "";
        String initializeBlock = "";
        String pluginsScriptBlock = "";
        TreeSet<String> properties = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        TreeSet<String> tasks = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        Matcher matcher = _importsPattern.matcher(content);
        while (matcher.find()) {
            importsBlock = importsBlock + matcher.group();
            content = StringUtil.replaceFirst(content, matcher.group(), "");
        }
        Matcher taskMatcher = _taskPattern.matcher(content);
        for (String line : StringUtil.splitLines(content)) {
            if (Validator.isNull(buildScriptBlock) && line.matches("^buildscript\\s+.*\\{")) {
                buildScriptBlock = line;
                continue;
            }
            if (Validator.isNotNull(buildScriptBlock) && !buildScriptBlock.endsWith("\n}")) {
                buildScriptBlock = buildScriptBlock + "\n" + line;
                continue;
            }
            if (Validator.isNull(extScriptBlock) && line.matches("^ext\\s+.*\\{")) {
                extScriptBlock = line;
                continue;
            }
            if (Validator.isNotNull(extScriptBlock) && !extScriptBlock.endsWith("\n}")) {
                extScriptBlock = extScriptBlock + "\n" + line;
                continue;
            }
            if (Validator.isNull(pluginsScriptBlock) && line.matches("^plugins\\s+.*\\{")) {
                pluginsScriptBlock = line;
                continue;
            }
            if (Validator.isNotNull(pluginsScriptBlock) && !pluginsScriptBlock.endsWith("\n}")) {
                pluginsScriptBlock = pluginsScriptBlock + "\n" + line;
                continue;
            }
            if (line.matches("^apply plugin.*")) {
                applyPlugins.add(line);
                continue;
            }
            if (line.matches("^sourceCompatibility\\s*=.*$")) {
                properties.add(line);
                continue;
            }
            if (line.matches("^targetCompatibility\\s*=.*$")) {
                properties.add(line);
                continue;
            }
            if (line.matches("^task\\s+.*$") && !line.contains("{")) {
                tasks.add(line);
                continue;
            }
            if (taskMatcher.matches() && tasks.isEmpty()) {
                initializeBlock = initializeBlock + "\n" + line;
                continue;
            }
            bodyBlock = bodyBlock + "\n" + line;
        }
        return new GradleFile(applyPlugins, StringUtil.trim(bodyBlock), StringUtil.trim(buildScriptBlock), content, StringUtil.trim(extScriptBlock), fileName, importsBlock, StringUtil.trim(initializeBlock), StringUtil.trim(pluginsScriptBlock), properties, tasks);
    }
}

