/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONValidationCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (Validator.isNull(content)) {
            return content;
        }
        content = this._removeJSONComments(content);
        try {
            if (StringUtil.startsWith(StringUtil.trim(content), "[")) {
                new JSONArray(content);
            } else {
                new JSONObject(content);
            }
        }
        catch (JSONException jsonException) {
            this.addMessage(fileName, jsonException.getMessage());
        }
        return content;
    }

    private String _removeJSONComments(String content) throws IOException {
        int x = -1;
        while ((x = content.indexOf("/*", x + 1)) != -1) {
            if (ToolsUtil.isInsideQuotes(content, x)) continue;
            int y = content.indexOf("*/", x + 2);
            return content.substring(0, x) + content.substring(y + 2);
        }
        x = -1;
        while ((x = content.indexOf("//", x + 1)) != -1) {
            if (ToolsUtil.isInsideQuotes(content, x)) continue;
            int y = content.indexOf("\n", x);
            if (y != -1) {
                return content.substring(0, x) + content.substring(y);
            }
            return content.substring(0, x);
        }
        return content;
    }
}

