/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.List;

public class OSGiResourceBuilderCheck
extends BaseCheck {
    private static final String _MSG_AVOID_METHOD_CALL = "method.call.avoid";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST annotationDetailAST = AnnotationUtil.getAnnotation((DetailAST)detailAST, (String)"Component");
        if (annotationDetailAST == null) {
            return;
        }
        List<String> importNames = null;
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            String methodName = this.getMethodName(methodCallDetailAST);
            if (!methodName.equals("builder")) continue;
            String classOrVariableName = this.getClassOrVariableName(methodCallDetailAST);
            if (classOrVariableName == null || !classOrVariableName.matches("[A-Z].*Resource")) {
                return;
            }
            if (importNames == null) {
                importNames = this.getImportNames(methodCallDetailAST);
            }
            String fullyQualifiedClassName = classOrVariableName;
            for (String importName : importNames) {
                if (!importName.endsWith("." + classOrVariableName)) continue;
                fullyQualifiedClassName = importName;
                break;
            }
            if (fullyQualifiedClassName.contains(".client.")) continue;
            this.log(methodCallDetailAST, _MSG_AVOID_METHOD_CALL, new Object[0]);
        }
    }
}

