/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.BaseImportsFormatter;
import com.liferay.portal.tools.ImportPackage;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiImportsFormatter
extends BaseImportsFormatter {
    private static final Pattern _importsPattern = Pattern.compile("\n((^[ \t]*import\\s+.*;\n+)+)", 8);

    @Override
    protected ImportPackage createImportPackage(String line) {
        return this.createJavaImportPackage(line);
    }

    @Override
    protected String doFormat(String content, Pattern importPattern, String packagePath, String className) throws IOException {
        Matcher matcher = _importsPattern.matcher(content);
        while (matcher.find()) {
            String newImports;
            String imports = matcher.group(1);
            if (imports.endsWith("\n\n")) {
                imports = imports.substring(0, imports.length() - 1);
            }
            if (imports.equals(newImports = this.sortAndGroupImports(imports))) continue;
            return StringUtil.replace(content, imports, newImports);
        }
        return content;
    }
}

