/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseIfStatementCheck
extends BaseFileCheck {
    private static final Pattern _methodCallPattern = Pattern.compile("\\w\\(");

    protected void checkIfClauseParentheses(String ifClause, String fileName, int lineNumber, boolean checkMissingParentheses) {
        if ((ifClause = SourceUtil.stripQuotes(ifClause)).matches("[^()]*\\((\\(?\\w+ instanceof \\w+\\)?( \\|\\| )?)+\\)[^()]*") && !ifClause.matches("[^()]*\\([^()]*\\)[^()]*")) {
            this.addMessage(fileName, "Redundant parentheses", lineNumber);
            return;
        }
        if (ifClause.contains("//") || ifClause.contains("/*") || ifClause.contains("*/")) {
            return;
        }
        if (checkMissingParentheses) {
            this._checkMissingParentheses(ifClause, fileName, lineNumber);
        }
        if (this._hasRedundantParentheses(ifClause, "||", "&&") || this._hasRedundantParentheses(ifClause, "&&", "||")) {
            this.addMessage(fileName, "Redundant parentheses", lineNumber);
            return;
        }
        int x = ifClause.indexOf("(");
        while (true) {
            String s;
            String s2;
            if ((x = ifClause.indexOf("(", x + 1)) == -1) {
                return;
            }
            char previousChar = ifClause.charAt(x - 1);
            if (previousChar != '!' && previousChar != '(' && previousChar != ' ' || previousChar == ' ' && Character.isLetterOrDigit((s2 = StringUtil.trim(ifClause.substring(0, x - 1))).charAt(s2.length() - 1))) continue;
            int y = x;
            while (this.getLevel(s = ifClause.substring(x + 1, y = ifClause.indexOf(")", y + 1))) != 0) {
            }
            char nextChar = ifClause.charAt(y + 1);
            if (previousChar == '(' && nextChar == ')') {
                this.addMessage(fileName, "Redundant parentheses", lineNumber);
                return;
            }
            if ((nextChar == ')' || nextChar == ' ') && this._hasRedundantParentheses(s)) break;
        }
        this.addMessage(fileName, "Redundant parentheses", lineNumber);
    }

    private void _checkMissingParentheses(String ifClause, String fileName, int lineNumber) {
        Matcher matcher;
        int x = -1;
        while (true) {
            int y = ifClause.indexOf("||", x + 1);
            int z = ifClause.indexOf("&&", x + 1);
            if (y == -1 || z == -1) break;
            String s = ifClause.substring(Math.min(y, z), Math.max(y, z));
            if (this.getLevel(s) == 0) {
                this.addMessage(fileName, "Missing parentheses", lineNumber);
                return;
            }
            x = Math.min(y, z);
        }
        block1: while ((matcher = _methodCallPattern.matcher(ifClause)).find()) {
            x = matcher.start() + 1;
            while ((x = ifClause.indexOf(")", x + 1)) != -1) {
                String s = ifClause.substring(matcher.start() + 1, x + 1);
                if (this.getLevel(s) != 0) continue;
                ifClause = StringUtil.replaceFirst(ifClause, s, "", matcher.start());
                continue block1;
            }
            break block1;
        }
        int previousParenthesisPos = -1;
        for (int i = 0; i < ifClause.length(); ++i) {
            String s;
            char c = ifClause.charAt(i);
            if (c != '(' && c != ')') continue;
            if (previousParenthesisPos != -1 && this._hasMissingParentheses(s = ifClause.substring(previousParenthesisPos + 1, i))) {
                this.addMessage(fileName, "Missing parentheses", lineNumber);
                return;
            }
            previousParenthesisPos = i;
        }
    }

    private boolean _hasMissingParentheses(String s) {
        if (Validator.isNull(s)) {
            return false;
        }
        boolean containsAndOperator = s.contains("&&");
        boolean containsOrOperator = s.contains("||");
        if (containsAndOperator && containsOrOperator) {
            return true;
        }
        boolean containsCompareOperator = false;
        if (s.contains(" == ") || s.contains(" != ") || s.contains(" < ") || s.contains(" > ") || s.contains(" =< ") || s.contains(" => ") || s.contains(" <= ") || s.contains(" >= ")) {
            containsCompareOperator = true;
        }
        boolean containsMathOperator = false;
        if (s.contains(" = ") || s.contains(" - ") || s.contains(" + ") || s.contains(" & ") || s.contains(" % ") || s.contains(" * ") || s.contains(" / ")) {
            containsMathOperator = true;
        }
        if (containsCompareOperator && (containsAndOperator || containsOrOperator || containsMathOperator && !s.contains("["))) {
            return true;
        }
        return s.contains(" ? ") && (containsAndOperator || containsCompareOperator || containsOrOperator);
    }

    private boolean _hasRedundantParentheses(String s) {
        int x = -1;
        while ((x = s.indexOf(" ", x + 1)) != -1) {
            if (this.getLevel(s.substring(0, x)) != 0) continue;
            return false;
        }
        return true;
    }

    private boolean _hasRedundantParentheses(String s, String operator1, String operator2) {
        int x;
        while ((x = s.indexOf("!(")) != -1) {
            String linePart;
            int y = x;
            while (this.getLevel(linePart = s.substring(x, (y = s.indexOf(")", y + 1)) + 1)) != 0) {
            }
            s = StringUtil.replaceFirst(s, ")", "", y);
            s = StringUtil.replaceFirst(s, "!(", "", x);
        }
        String[] parts = StringUtil.split(s, operator1);
        if (parts.length < 3) {
            return false;
        }
        for (int i = 1; i < parts.length - 1; ++i) {
            String part = parts[i];
            if (part.contains(operator2) || Math.abs(this.getLevel(part)) != 1) continue;
            return true;
        }
        return false;
    }
}

